/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.repository;

import net.anotheria.moskito.webcontrol.repository.Attribute;
import net.anotheria.moskito.webcontrol.repository.formulas.Formula;
import net.anotheria.moskito.webcontrol.repository.formulas.FormulaFactory;

public class FormulaAttribute
extends Attribute {
    private Object value;

    public FormulaAttribute(String name, String formulaClass, Attribute ... inputs) {
        super(name);
        Formula f = FormulaFactory.getFormula((String)formulaClass);
        if (f == null) {
            throw new RuntimeException("formula `" + formulaClass + "` does not exist");
        }
        if (this.checkInputs(f, inputs)) {
            this.value = f.calculate(inputs);
        }
    }

    private boolean checkInputs(Formula f, Attribute ... inputs) {
        if (inputs != null && f.isArgumentsAcceptable(inputs)) {
            for (Attribute a : inputs) {
                if (!(a instanceof FormulaAttribute)) continue;
            }
            return true;
        }
        return false;
    }

    public String getValueString() {
        return String.valueOf(this.value);
    }

    public Object getValue() {
        return this.value;
    }
}

