/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.repository;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.webcontrol.repository.Container;
import net.anotheria.moskito.webcontrol.repository.Snapshot;
import net.anotheria.moskito.webcontrol.repository.SnapshotSource;

public enum Repository {
    INSTANCE;

    private ConcurrentMap<String, Container> containers = new ConcurrentHashMap();

    public List<Snapshot> getSnapshots(String containerName) {
        return this.getContainer(containerName).getSnapshots();
    }

    public Snapshot getSnapshot(String containerName, SnapshotSource source) {
        Snapshot s = this.getContainer(containerName).getSnapshot(source);
        if (s == null) {
            throw new NullPointerException("ProducerSnapshot " + containerName + " from " + source + " not found.");
        }
        return s;
    }

    public void addSnapshot(String containerName, Snapshot snapshot) {
        this.getContainer(containerName).addSnapshot(snapshot);
    }

    private Container getContainer(String containerName) {
        Container c = (Container)this.containers.get(containerName);
        if (c == null) {
            c = new Container(containerName);
            this.containers.putIfAbsent(containerName, c);
        }
        return c;
    }

    public void clear() {
        this.containers.clear();
    }
}

