/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.anotheria.moskito.webcontrol.configuration.ConfigurationRepository;
import net.anotheria.moskito.webcontrol.configuration.StatsSource;
import net.anotheria.moskito.webcontrol.configuration.ViewConfiguration;
import net.anotheria.moskito.webcontrol.configuration.ViewField;
import net.anotheria.moskito.webcontrol.feed.HttpGetter;
import net.anotheria.moskito.webcontrol.repository.Attribute;
import net.anotheria.moskito.webcontrol.repository.AttributeFactory;
import net.anotheria.moskito.webcontrol.repository.AttributeType;
import net.anotheria.moskito.webcontrol.repository.Repository;
import net.anotheria.moskito.webcontrol.repository.RepositoryUpdater;
import net.anotheria.moskito.webcontrol.repository.Snapshot;
import net.anotheria.moskito.webcontrol.repository.SnapshotSource;
import net.anotheria.moskito.webcontrol.repository.StringAttribute;
import net.anotheria.moskito.webcontrol.repository.TotalFormulaType;
import net.anotheria.moskito.webcontrol.ui.beans.PatternWithName;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RepositoryUpdater {
    private static RepositoryUpdater instance;
    private Logger log = Logger.getLogger(RepositoryUpdater.class);
    private Timer timer;
    private long period;
    private static final long DEFAULT_PERIOD = 60000L;

    private RepositoryUpdater(long aPeriod) {
        this.period = aPeriod;
        try {
            ConfigurationRepository.INSTANCE.loadViewsConfiguration();
            ConfigurationRepository.INSTANCE.loadAllAvailableColumns();
        }
        catch (Exception e) {
            this.log.error((Object)"RepositoryUpdater() can't instantiate or load moskito repository", (Throwable)e);
            instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RepositoryUpdater getInstance() {
        if (instance != null) return instance;
        Class<RepositoryUpdater> clazz = RepositoryUpdater.class;
        synchronized (RepositoryUpdater.class) {
            if (instance != null) return instance;
            instance = new RepositoryUpdater(60000L);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void start(Long aPeriod) {
        this.stop();
        this.timer = new Timer("MoskitoRepositoryUpdater", true);
        this.period = aPeriod == null ? 60000L : aPeriod;
        this.timer.schedule((TimerTask)new CheckTask(this, null), 1L, this.period);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public void update() {
        List sources = ConfigurationRepository.INSTANCE.getSources();
        for (StatsSource source : sources) {
            if ("Totals".equalsIgnoreCase(source.getName())) continue;
            for (String name : ConfigurationRepository.INSTANCE.getIntervalsNames()) {
                try {
                    HttpGetter getter = new HttpGetter();
                    StatsSource sourceConf = source.build("&pInterval=" + name);
                    Document doc = getter.retreive(sourceConf);
                    if (doc != null) {
                        this.fillRepository(source, doc, ConfigurationRepository.INSTANCE.getContainerName(name));
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                this.executeGuards(ConfigurationRepository.INSTANCE.getContainerName(name), source.getName());
            }
        }
        for (String name : ConfigurationRepository.INSTANCE.getIntervalsNames()) {
            this.calculateTotals(ConfigurationRepository.INSTANCE.getContainerName(name));
        }
    }

    private void executeGuards(String containerName, String sourceConfigName) {
        Snapshot ss = null;
        try {
            ss = Repository.INSTANCE.getSnapshot(containerName, new SnapshotSource(sourceConfigName));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (ss == null) {
            return;
        }
        List viewNames = ConfigurationRepository.INSTANCE.getViewNames();
        for (String viewName : viewNames) {
            ViewConfiguration viewConfig = ConfigurationRepository.INSTANCE.getView(viewName);
            List fields = viewConfig.getFields();
            for (ViewField field : fields) {
                Attribute attr = ss.getAttribute(field.getAttributeName());
                try {
                    if (field.getGuard() == null) continue;
                    field.getGuard().execute(ss, field, attr);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void calculateTotals(String containerName) {
        Snapshot snapshot = new Snapshot(new SnapshotSource("Totals"));
        List viewNames = ConfigurationRepository.INSTANCE.getViewNames();
        for (String viewName : viewNames) {
            ViewConfiguration viewConfig = ConfigurationRepository.INSTANCE.getView(viewName);
            List fields = viewConfig.getFields();
            for (ViewField field : fields) {
                if (!field.getTotal().equals((Object)TotalFormulaType.EMPTY)) {
                    ArrayList<Attribute> attrs = new ArrayList<Attribute>();
                    List sources = ConfigurationRepository.INSTANCE.getSources();
                    for (StatsSource source : sources) {
                        if ("Totals".equalsIgnoreCase(source.getName())) continue;
                        try {
                            Snapshot ss = Repository.INSTANCE.getSnapshot(containerName, new SnapshotSource(source.getName()));
                            attrs.add(ss.getAttribute(field.getAttributeName()));
                        }
                        catch (Exception e) {
                            this.log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    Attribute[] ats = attrs.toArray(new Attribute[attrs.size()]);
                    try {
                        snapshot.addAttribute((Attribute)AttributeFactory.createFormula((String)field.getAttributeName(), (String)field.getTotal().getFormulaClass(), (Attribute[])ats));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                snapshot.addAttribute((Attribute)new StringAttribute(field.getAttributeName(), ""));
            }
        }
        StatsSource s = new StatsSource(snapshot.getSource().toString(), "");
        ConfigurationRepository.INSTANCE.addSource(s);
        Repository.INSTANCE.addSnapshot(containerName, snapshot);
    }

    public void fillRepository(StatsSource source, Document doc, String containerName) {
        Repository.INSTANCE.addSnapshot(containerName, this.createSnapshot(source.getName(), doc));
    }

    private Snapshot createSnapshot(String name, Document doc) {
        Snapshot snapshot = new Snapshot(new SnapshotSource(name));
        List viewNames = ConfigurationRepository.INSTANCE.getViewNames();
        for (String viewName : viewNames) {
            ViewField field;
            int j;
            ViewConfiguration viewConfig = ConfigurationRepository.INSTANCE.getView(viewName);
            List fields = viewConfig.getFields();
            ViewField[] fs = fields.toArray(new ViewField[fields.size()]);
            block8: for (j = 0; j < fs.length; ++j) {
                field = fs[j];
                switch (1.$SwitchMap$net$anotheria$moskito$webcontrol$repository$ColumnType[field.getType().ordinal()]) {
                    case 1: {
                        boolean wildcard = ConfigurationRepository.isWildCard((String)field.getPath());
                        if (!wildcard) continue block8;
                        fs[j] = null;
                        fields.remove(field);
                        this.addFieldByWildCard(viewConfig, field, snapshot, field.getAttributeName(), doc);
                        continue block8;
                    }
                }
            }
            block9: for (j = 0; j < fields.size(); ++j) {
                field = (ViewField)fields.get(j);
                switch (1.$SwitchMap$net$anotheria$moskito$webcontrol$repository$ColumnType[field.getType().ordinal()]) {
                    case 2: {
                        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
                        for (String f : field.getInputs()) {
                            Attribute attr = this.getAttribute(snapshot, fields, f, doc);
                            attrs.add(attr);
                        }
                        Attribute[] ats = attrs.toArray(new Attribute[attrs.size()]);
                        snapshot.addAttribute((Attribute)AttributeFactory.createFormula((String)field.getAttributeName(), (String)field.getJavaType(), (Attribute[])ats));
                        continue block9;
                    }
                    case 1: {
                        snapshot.addAttribute(this.getAttribute(snapshot, fields, field.getAttributeName(), doc));
                    }
                }
            }
        }
        return snapshot;
    }

    private Attribute getAttribute(Snapshot snapshot, List<ViewField> fields, String input, Document doc) {
        Attribute attr = snapshot.getAttribute(input);
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (attr == null) {
            for (ViewField field : fields) {
                if (!field.getAttributeName().equals(input)) continue;
                try {
                    Node value = (Node)xpath.compile(field.getPath()).evaluate(doc, XPathConstants.NODE);
                    if (value != null) {
                        attr = AttributeFactory.create((AttributeType)AttributeType.convert((String)field.getJavaType()), (String)field.getAttributeName(), (String)value.getNodeValue());
                        break;
                    }
                    attr = AttributeFactory.create((AttributeType)AttributeType.convert((String)field.getJavaType()), (String)field.getAttributeName(), (String)"0");
                    break;
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return attr;
    }

    private void addFieldByWildCard(ViewConfiguration viewConfig, ViewField field, Snapshot snapshot, String input, Document doc) {
        Attribute attr = snapshot.getAttribute(input);
        if (attr == null && field.getAttributeName().equals(input)) {
            try {
                ArrayList<PatternWithName> result = new ArrayList<PatternWithName>();
                result.add(new PatternWithName("", field.getPath()));
                ConfigurationRepository.buildFullPath(result, (Document)doc);
                for (PatternWithName p : result) {
                    ViewField newField = (ViewField)field.clone();
                    newField.setFieldName(p.getFieldName() + "_" + field.getFieldName());
                    newField.setAttributeName(p.getFieldName() + "_" + field.getFieldName());
                    newField.setPath(p.getPattern());
                    viewConfig.addField(newField);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

