/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.repository;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.webcontrol.repository.Attribute;
import net.anotheria.moskito.webcontrol.repository.SnapshotSource;

public class Snapshot {
    private SnapshotSource source;
    private long created;
    private ConcurrentMap<String, Attribute> attributes;

    public Snapshot(SnapshotSource aSource) {
        this.source = aSource;
        this.created = System.currentTimeMillis();
        this.attributes = new ConcurrentHashMap();
    }

    public SnapshotSource getSource() {
        return this.source;
    }

    public long getCreatedTimestamp() {
        return this.created;
    }

    public Attribute addAttribute(Attribute a) {
        return this.attributes.put(a.getName(), a);
    }

    public Attribute getAttribute(String attributeName) {
        return (Attribute)this.attributes.get(attributeName);
    }

    public void removeAttribute(Attribute a) {
        this.attributes.remove(a.getName());
    }

    public List<Attribute> getAttributes() {
        return (List)this.attributes.values();
    }

    public String toString() {
        return this.source + " " + this.created + " " + this.attributes;
    }
}

