/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.ui.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionForward;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.maf.bean.FormBean;
import net.anotheria.moskito.webcontrol.configuration.ConfigurationRepository;
import net.anotheria.moskito.webcontrol.ui.action.BaseMoskitoWebcontrolAction;
import net.anotheria.moskito.webcontrol.ui.beans.ColumnBean;
import net.anotheria.moskito.webcontrol.ui.beans.ComparableOrderedSource;
import net.anotheria.moskito.webcontrol.ui.beans.ViewTable;
import net.anotheria.util.StringUtils;

public class ShowViewAction
extends BaseMoskitoWebcontrolAction {
    public ActionForward execute(ActionMapping mapping, FormBean bean, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String interval;
        List viewnames = ConfigurationRepository.INSTANCE.getViewNames();
        ArrayList<ViewTable> viewTable = new ArrayList<ViewTable>();
        String sortBy = req.getParameter("pFilterSortBy");
        String sortOrder = req.getParameter("pFilterSortOrder");
        String currentViewname = req.getParameter("pViewName");
        if (currentViewname == null && viewnames.size() > 0) {
            currentViewname = (String)viewnames.get(0);
        }
        if (StringUtils.isEmpty((String)(interval = req.getParameter("pInterval")))) {
            interval = "default";
        }
        for (String viewName : viewnames) {
            viewTable.add(this.prepareView(viewName, interval));
        }
        req.setAttribute("viewTable", viewTable);
        ViewTable view = this.prepareView(currentViewname, interval);
        if (sortBy != null) {
            this.sorting(view, sortBy, sortOrder);
        }
        String indication = view.getColor().toString();
        req.setAttribute("view", (Object)view);
        req.setAttribute("indication", (Object)indication);
        req.setAttribute("interval", (Object)interval);
        req.setAttribute("intervalNames", (Object)ConfigurationRepository.INSTANCE.getIntervalsNames());
        req.setAttribute("sortBy", (Object)sortBy);
        req.setAttribute("sortOrder", (Object)sortOrder);
        return mapping.findForward("success");
    }

    private void sorting(ViewTable viewTable, String sortBy, String sortOrder) {
        int attrNumber = this.getAttributeNumber(viewTable.getRowNames(), sortBy);
        Collections.sort(viewTable.getValues(), new ComparableOrderedSource(attrNumber, sortOrder.equalsIgnoreCase("desc") ? -1 : 1));
    }

    private int getAttributeNumber(List<ColumnBean> rowNames, String sortBy) {
        for (int i = 0; i < rowNames.size(); ++i) {
            ColumnBean field = rowNames.get(i);
            if (!field.getKey().equalsIgnoreCase(sortBy)) continue;
            return i;
        }
        throw new RuntimeException("SortBy attribute `" + sortBy + "` does not exist in list of view fields.");
    }
}

