/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.ui.beans;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.webcontrol.guards.Condition;
import net.anotheria.moskito.webcontrol.ui.beans.AttributeBean;
import net.anotheria.moskito.webcontrol.ui.beans.ColumnBean;
import net.anotheria.moskito.webcontrol.ui.beans.OrderedSourceAttributesBean;
import net.anotheria.util.StringUtils;

public class ViewTable {
    private final String viewName;
    private Condition color = Condition.GREEN;
    private List<ColumnBean> rowNames;
    private List<OrderedSourceAttributesBean> values;

    public ViewTable(String viewName) {
        this.viewName = viewName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setRowNames(List<ColumnBean> rowNames) {
        this.rowNames = rowNames;
    }

    public List<ColumnBean> getRowNames() {
        return this.rowNames;
    }

    public void setValues(List<OrderedSourceAttributesBean> values) {
        this.values = values;
    }

    public List<OrderedSourceAttributesBean> getValues() {
        return this.values;
    }

    public boolean addRowName(ColumnBean rowName) throws Exception {
        if (this.rowNames == null) {
            this.rowNames = new ArrayList();
        }
        return this.rowNames.add(rowName);
    }

    public boolean addValueBean(OrderedSourceAttributesBean bean) throws Exception {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        return this.values.add(bean);
    }

    public void setColor(String aColor) {
        this.color = Condition.getValueByColor((String)aColor);
        for (OrderedSourceAttributesBean osab : this.values) {
            for (AttributeBean abean : osab.getAttributeValues()) {
                if (StringUtils.isEmpty((String)abean.getColor())) continue;
                Condition colorCondition = Condition.getValueByColor((String)abean.getColor());
                if (this.color.getPriority() > colorCondition.getPriority()) {
                    this.color = colorCondition;
                }
                if (this.color != Condition.RED) continue;
                return;
            }
        }
    }

    public Condition getColor() {
        return this.color;
    }
}

