/*
 * Decompiled with CFR 0.152.
 */
package net.anthavio.phanbedder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Phanbedder {
    public static final String PHANTOMJS_VERSION = "2.1.1";

    public static File unpack() {
        String javaIoTmpdir = System.getProperty("java.io.tmpdir");
        return Phanbedder.unpack(new File(javaIoTmpdir, "phantomjs-2.1.1"));
    }

    public static String unpack(String directory) {
        File file = Phanbedder.unpack(new File(directory));
        return file.getAbsolutePath();
    }

    public static File unpack(File directory) {
        boolean chmodx;
        File file;
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IllegalArgumentException("Failed to make target directory: " + directory);
        }
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.contains("win")) {
            file = new File(directory, "phantomjs.exe");
            Phanbedder.unpack("windows/phantomjs.exe", file);
            chmodx = false;
        } else if (osname.contains("mac os")) {
            file = new File(directory, "phantomjs");
            Phanbedder.unpack("macosx/phantomjs", file);
            chmodx = true;
        } else if (osname.contains("linux")) {
            file = new File(directory, "phantomjs");
            String osarch = System.getProperty("os.arch");
            if (osarch.equals("i386")) {
                Phanbedder.unpack("linux86/phantomjs", file);
            } else {
                Phanbedder.unpack("linux64/phantomjs", file);
            }
            chmodx = true;
        } else {
            throw new IllegalArgumentException("Unsupported OS " + osname);
        }
        if (chmodx && !file.setExecutable(true)) {
            throw new IllegalArgumentException("Failed to make executable " + file);
        }
        return file;
    }

    private static void unpack(String resource, File target) {
        if (target.exists() && target.isFile() && target.canExecute()) {
            return;
        }
        ClassLoader classLoader = Phanbedder.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(resource);
        if (stream == null) {
            throw new IllegalStateException("Resource not found " + resource + " using ClassLoader " + classLoader);
        }
        BufferedInputStream input = new BufferedInputStream(stream);
        FilterOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(target));
            while (input.available() > 0) {
                byte[] buffer = new byte[input.available()];
                input.read(buffer);
                output.write(buffer);
            }
            ((BufferedOutputStream)output).flush();
        }
        catch (Exception x) {
            throw new IllegalStateException("Failed to unpack resource: " + resource + " into: " + target, x);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iox) {}
            }
            try {
                input.close();
            }
            catch (IOException iox) {}
        }
    }
}

