/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.gronk;

import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowJar;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.auoeke.gronk.GronkExtension;
import net.auoeke.gronk.ManifestMerger;
import net.auoeke.gronk.ManifestMergerExtension;
import net.auoeke.gronk.MavenRepositoryExtension;
import net.auoeke.gronk.Util;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.jvm.tasks.Jar;
import org.gradle.plugins.signing.SigningExtension;

public class Gronk
implements Plugin<Project> {
    public void apply(Project project) {
        GronkExtension extension = (GronkExtension)project.getExtensions().create("gronk", GronkExtension.class, new Object[]{project});
        Util.tryAddExtension((ExtensionAware)project, "systemProperty", Util.functionClosure(System::getProperty));
        Util.tryAddExtension((ExtensionAware)project, "url", Util.actionClosure(extension::url));
        Util.javaExtension(project, java -> {
            Util.tryAddExtension((ExtensionAware)project, "javaVersion", Util.actionClosure(extension::javaVersion));
            SourceSetContainer sets = java.getSourceSets();
            SourceSet main = (SourceSet)sets.getByName("main");
            main.getJava().srcDir((Object)"source");
            main.resources(resources -> resources.srcDir((Object)"resources"));
            SourceDirectorySet test = ((SourceSet)sets.getByName("test")).getJava();
            test.setSrcDirs(List.of(project.file((Object)"test/source").exists() ? "test/source" : "test"));
            HashSet sourcesJarNames = new HashSet();
            java.getSourceSets().all(set -> sourcesJarNames.add(set.getSourcesJarTaskName()));
            project.getTasks().withType(Jar.class).matching(task -> sourcesJarNames.contains(task.getName())).all(task -> task.eachFile(file -> file.setPath(file.getPath().replaceAll("\\.(?=.*/)", "/"))));
            Util.whenPluginPresent(project, "com.github.johnrengelman.shadow", plugin -> {
                project.getTasks().withType(ShadowJar.class, ManifestMergerExtension::inject);
                project.getExtensions().add(Class.class, "ManifestMerger", ManifestMerger.class);
            });
        });
        MavenRepositoryExtension.inject(project, project.getRepositories());
        project.getConfigurations().all(configuration -> configuration.getDependencies().withType(ExternalDependency.class, dependency -> {
            if (dependency.getVersion() == null || dependency.getVersion().isEmpty()) {
                dependency.version(constraint -> constraint.prefer(extension.fallbackVersion));
            }
        }));
        Util.whenExtensionPresent(project, PublishingExtension.class, publish -> {
            Util.javaExtension(project, JavaPluginExtension::withSourcesJar);
            MavenRepositoryExtension.inject(project, publish.getRepositories());
            project.afterEvaluate(p -> p.getPluginManager().withPlugin("maven-publish", plugin -> publish.publications(publications -> {
                if (publications.isEmpty() && !project.getGroup().toString().isEmpty()) {
                    publications.register("maven", MavenPublication.class, pub -> Gronk.configure(project.getComponents(), "java", arg_0 -> ((MavenPublication)pub).from(arg_0)));
                }
                publications.withType(MavenPublication.class, publication -> {
                    publication.versionMapping(strategy -> strategy.allVariants(VariantVersionMappingStrategy::fromResolutionResult));
                    if (!project.getPluginManager().hasPlugin("com.gradle.plugin-publish")) {
                        Util.whenExtensionPresent(project, SigningExtension.class, signing -> signing.sign(new Publication[]{publication}));
                    }
                    publication.pom(pom -> {
                        if (!pom.getName().isPresent()) {
                            pom.getName().set((Object)project.getName());
                        }
                        if (!pom.getDescription().isPresent()) {
                            pom.getDescription().set((Object)project.getDescription());
                        }
                        if (!pom.getUrl().isPresent()) {
                            pom.getUrl().set((Object)extension.url);
                        }
                    });
                });
            })));
        });
    }

    private static <T> void configure(NamedDomainObjectCollection<T> collection, String name, Consumer<T> configure) {
        Optional.ofNullable(collection.findByName(name)).ifPresent(configure);
    }
}

