/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.gronk;

import java.io.File;
import java.net.URL;
import java.util.List;
import net.auoeke.gronk.ClosureExtension;
import net.auoeke.gronk.PasswordExtension;
import net.auoeke.gronk.UsernameExtension;
import net.auoeke.gronk.Util;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.plugins.ExtensionAware;

public class MavenRepositoryExtension
extends ClosureExtension<RepositoryHandler, MavenArtifactRepository> {
    private final Project project;

    public MavenRepositoryExtension(RepositoryHandler owner, Project project) {
        super(owner);
        this.project = project;
    }

    public static void inject(Project project, RepositoryHandler repositories) {
        MavenRepositoryExtension.inject(repositories, "maven", project);
    }

    public MavenArtifactRepository doCall(Object url, Action<MavenArtifactRepository> configure) {
        return this.repositories().maven(repository -> {
            Object object;
            if (url instanceof String) {
                String string = (String)url;
                object = Util.tryCatch(() -> this.project.file((Object)string)).filter(File::exists).map(Object.class::cast).or(() -> Util.tryCatch(() -> new URL(string))).orElse("https://" + string);
            } else {
                object = url;
            }
            Object url1 = object;
            repository.setUrl(url1);
            repository.setName(url1.toString().replaceFirst("^.*?://", "").replace('/', '-'));
            if (repository instanceof ExtensionAware) {
                UsernameExtension.inject((AuthenticationSupported)repository);
                PasswordExtension.inject((AuthenticationSupported)repository);
            }
            this.project.configure(List.of(repository), configure);
            if (repository.getName().equals("maven")) {
                throw new IllegalArgumentException("\"maven\" is a bad repository name.");
            }
        });
    }

    public MavenArtifactRepository doCall(Object url) {
        return this.doCall(url, (Action<MavenArtifactRepository>)((Action)repository -> {}));
    }

    private RepositoryHandler repositories() {
        return (RepositoryHandler)this.getOwner();
    }
}

