/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.HttpPart;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.MBeans;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.SessionInformations;
import net.bull.javamelody.internal.model.VirtualMachine;
import net.bull.javamelody.internal.web.HttpCookieManager;
import net.bull.javamelody.internal.web.RequestToMethodMapper;
import net.bull.javamelody.internal.web.pdf.PdfOtherReport;
import net.bull.javamelody.internal.web.pdf.PdfReport;

class PdfController {
    private static final String RANGE_KEY = "range";
    private static final String JAVA_INFORMATIONS_LIST_KEY = "javaInformationsList";
    private static final RequestToMethodMapper<PdfController> REQUEST_TO_METHOD_MAPPER = new RequestToMethodMapper<PdfController>(PdfController.class);
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final Collector collector;
    private final CollectorServer collectorServer;
    private PdfOtherReport pdfOtherReport;

    PdfController(Collector collector, CollectorServer collectorServer) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPdf(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        this.addPdfContentTypeAndDisposition(httpRequest, httpResponse);
        try {
            String part = HttpParameter.PART.getParameterFrom(httpRequest);
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            if (part == null) {
                if (!this.isFromCollectorServer() && !this.collector.isStopped()) {
                    this.collector.collectLocalContextWithoutErrors();
                }
                PdfReport pdfReport = new PdfReport(this.collector, this.isFromCollectorServer(), javaInformationsList, range, (OutputStream)httpResponse.getOutputStream());
                pdfReport.toPdf();
            } else {
                this.pdfOtherReport = new PdfOtherReport(this.getApplication(), (OutputStream)httpResponse.getOutputStream());
                httpRequest.setAttribute(RANGE_KEY, (Object)range);
                httpRequest.setAttribute(JAVA_INFORMATIONS_LIST_KEY, javaInformationsList);
                REQUEST_TO_METHOD_MAPPER.invoke(httpRequest, this);
            }
        }
        finally {
            httpResponse.getOutputStream().flush();
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.CURRENT_REQUESTS)
    void doCurrentRequests(@RequestToMethodMapper.RequestAttribute(value="javaInformationsList") List<JavaInformations> javaInformationsList, @RequestToMethodMapper.RequestAttribute(value="range") Range range) throws IOException {
        Map<JavaInformations, List<CounterRequestContext>> currentRequests;
        List<Counter> counters = this.collector.getRangeCountersToBeDisplayed(range);
        if (!this.isFromCollectorServer()) {
            assert (this.collectorServer == null);
            assert (javaInformationsList.size() == 1);
            JavaInformations javaInformations = javaInformationsList.get(0);
            List<CounterRequestContext> rootCurrentContexts = this.collector.getRootCurrentContexts(counters);
            currentRequests = Collections.singletonMap(javaInformations, rootCurrentContexts);
        } else {
            currentRequests = this.collectorServer.collectCurrentRequests(this.collector.getApplication());
        }
        long timeOfSnapshot = System.currentTimeMillis();
        this.pdfOtherReport.writeAllCurrentRequestsAsPart(currentRequests, this.collector, counters, timeOfSnapshot);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.THREADS)
    void doThreads(@RequestToMethodMapper.RequestAttribute(value="javaInformationsList") List<JavaInformations> javaInformationsList) throws IOException {
        this.pdfOtherReport.writeThreads(javaInformationsList);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.RUNTIME_DEPENDENCIES)
    void doRuntimeDependencies(@RequestToMethodMapper.RequestAttribute(value="range") Range range, @RequestToMethodMapper.RequestParameter(value=HttpParameter.COUNTER) String counterName) throws IOException {
        Counter counter = this.collector.getRangeCounter(range, counterName);
        this.pdfOtherReport.writeRuntimeDependencies(counter, range);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.COUNTER_SUMMARY_PER_CLASS)
    void doCounterSummaryPerClass(@RequestToMethodMapper.RequestAttribute(value="range") Range range, @RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String requestId, @RequestToMethodMapper.RequestParameter(value=HttpParameter.COUNTER) String counterName) throws IOException {
        Counter counter = this.collector.getRangeCounter(range, counterName);
        this.pdfOtherReport.writeCounterSummaryPerClass(this.collector, counter, requestId, range);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.GRAPH)
    void doRequestAndGraphDetail(@RequestToMethodMapper.RequestAttribute(value="range") Range range, @RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String requestId) throws IOException {
        this.pdfOtherReport.writeRequestAndGraphDetail(this.collector, this.collectorServer, range, requestId);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.SESSIONS)
    void doSessions() throws IOException {
        Action.checkSystemActionsEnabled();
        List<SessionInformations> sessionsInformations = !this.isFromCollectorServer() ? SessionListener.getAllSessionsInformations() : this.collectorServer.collectSessionInformations(this.getApplication(), null);
        this.pdfOtherReport.writeSessionInformations(sessionsInformations);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.HOTSPOTS)
    void doHotspots() throws IOException {
        Action.checkSystemActionsEnabled();
        if (!this.isFromCollectorServer()) {
            List<SamplingProfiler.SampledMethod> hotspots = this.collector.getHotspots();
            this.pdfOtherReport.writeHotspots(hotspots);
        } else {
            List<SamplingProfiler.SampledMethod> hotspots = this.collectorServer.collectHotspots(this.getApplication());
            this.pdfOtherReport.writeHotspots(hotspots);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.PROCESSES)
    void doProcesses() throws IOException {
        Action.checkSystemActionsEnabled();
        if (!this.isFromCollectorServer()) {
            List<ProcessInformations> processInformations = ProcessInformations.buildProcessInformations();
            this.pdfOtherReport.writeProcessInformations(processInformations);
        } else {
            Map<String, List<ProcessInformations>> processesByTitle = this.collectorServer.collectProcessInformations(this.getApplication());
            this.pdfOtherReport.writeProcessInformations(processesByTitle);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.DATABASE)
    void doDatabase(@RequestToMethodMapper.RequestParameter(value=HttpParameter.REQUEST) String requestIndex) throws Exception {
        Action.checkSystemActionsEnabled();
        int index = DatabaseInformations.parseRequestIndex(requestIndex);
        DatabaseInformations databaseInformations = !this.isFromCollectorServer() ? new DatabaseInformations(index) : this.collectorServer.collectDatabaseInformations(this.getApplication(), index);
        this.pdfOtherReport.writeDatabaseInformations(databaseInformations);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.JNDI)
    void doJndi(@RequestToMethodMapper.RequestParameter(value=HttpParameter.PATH) String path) throws Exception {
        Action.checkSystemActionsEnabled();
        List<JndiBinding> jndiBindings = !this.isFromCollectorServer() ? JndiBinding.listBindings(path) : this.collectorServer.collectJndiBindings(this.getApplication(), path);
        this.pdfOtherReport.writeJndi(jndiBindings, JndiBinding.normalizePath(path));
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.MBEANS)
    void doMBeans() throws Exception {
        Action.checkSystemActionsEnabled();
        if (!this.isFromCollectorServer()) {
            List<MBeanNode> nodes = MBeans.getAllMBeanNodes();
            this.pdfOtherReport.writeMBeans(nodes);
        } else {
            Map<String, List<MBeanNode>> allMBeans = this.collectorServer.collectMBeans(this.getApplication());
            this.pdfOtherReport.writeMBeans(allMBeans);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.HEAP_HISTO)
    void doHeapHisto() throws Exception {
        Action.checkSystemActionsEnabled();
        HeapHistogram heapHistogram = !this.isFromCollectorServer() ? VirtualMachine.createHeapHistogram() : this.collectorServer.collectHeapHistogram(this.getApplication());
        this.pdfOtherReport.writeHeapHistogram(heapHistogram);
    }

    void addPdfContentTypeAndDisposition(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        httpResponse.setContentType("application/pdf");
        String contentDisposition = PdfController.encodeFileNameToContentDisposition(httpRequest, PdfReport.getFileName(this.getApplication()));
        httpResponse.addHeader("Content-Disposition", contentDisposition.replace('\n', '_').replace('\r', '_'));
    }

    private String getApplication() {
        return this.collector.getApplication();
    }

    private boolean isFromCollectorServer() {
        return this.collectorServer != null;
    }

    private static String encodeFileNameToContentDisposition(HttpServletRequest httpRequest, String fileName) {
        assert (fileName != null);
        String userAgent = httpRequest.getHeader("user-agent");
        if (userAgent != null && userAgent.contains("MSIE")) {
            return "attachment;filename=" + fileName;
        }
        return PdfController.encodeFileNameToStandardContentDisposition(fileName);
    }

    private static String encodeFileNameToStandardContentDisposition(String fileName) {
        int length = fileName.length();
        StringBuilder sb = new StringBuilder(length + length / 4);
        sb.append("attachment;filename=\"");
        for (int i = 0; i < length; ++i) {
            char c = fileName.charAt(i);
            if (PdfController.isEncodingNotNeeded(c)) {
                sb.append(c);
                continue;
            }
            sb.append('%');
            if (c < '\u0010') {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static boolean isEncodingNotNeeded(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_';
    }
}

