/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import jakarta.servlet.ServletContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.Referenceable;
import net.bull.javamelody.Parameter;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.tomcat.jdbc.pool.DataSource;

final class JdbcWrapperHelper {
    private static final String MAX_ACTIVE_PROPERTY_NAME = "maxActive";
    private static final Map<String, javax.sql.DataSource> SPRING_DATASOURCES = new LinkedHashMap<String, javax.sql.DataSource>();
    private static final Map<String, javax.sql.DataSource> JNDI_DATASOURCES_BACKUP = new LinkedHashMap<String, javax.sql.DataSource>();
    private static final Map<String, javax.sql.DataSource> REWRAPPED_DATASOURCES_BACKUP = new LinkedHashMap<String, javax.sql.DataSource>();
    private static final BasicDataSourcesProperties TOMCAT_BASIC_DATASOURCES_PROPERTIES = new BasicDataSourcesProperties();
    private static final BasicDataSourcesProperties DBCP_BASIC_DATASOURCES_PROPERTIES = new BasicDataSourcesProperties();
    private static final BasicDataSourcesProperties TOMCAT_JDBC_DATASOURCES_PROPERTIES = new BasicDataSourcesProperties();
    private static final Map<Class<?>, Constructor<?>> PROXY_CACHE = Collections.synchronizedMap(new WeakHashMap());

    private JdbcWrapperHelper() {
    }

    static void registerSpringDataSource(String name, javax.sql.DataSource dataSource) {
        SPRING_DATASOURCES.put(name, dataSource);
    }

    static void registerRewrappedDataSource(String name, javax.sql.DataSource dataSource) {
        REWRAPPED_DATASOURCES_BACKUP.put(name, dataSource);
    }

    static Map<String, javax.sql.DataSource> getRewrappedDataSources() {
        return REWRAPPED_DATASOURCES_BACKUP;
    }

    static void rebindDataSource(ServletContext servletContext, String jndiName, javax.sql.DataSource dataSource, javax.sql.DataSource dataSourceProxy) throws Throwable {
        Object lock = JdbcWrapperHelper.changeContextWritable(servletContext, null);
        InitialContext initialContext = new InitialContext();
        initialContext.rebind(jndiName, (Object)dataSourceProxy);
        JNDI_DATASOURCES_BACKUP.put(jndiName, dataSource);
        JdbcWrapperHelper.changeContextWritable(servletContext, lock);
        initialContext.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rebindInitialDataSources(ServletContext servletContext) throws Throwable {
        try {
            InitialContext initialContext = new InitialContext();
            for (Map.Entry<String, javax.sql.DataSource> entry : JNDI_DATASOURCES_BACKUP.entrySet()) {
                String jndiName = entry.getKey();
                javax.sql.DataSource dataSource = entry.getValue();
                Object lock = JdbcWrapperHelper.changeContextWritable(servletContext, null);
                initialContext.rebind(jndiName, (Object)dataSource);
                JdbcWrapperHelper.changeContextWritable(servletContext, lock);
            }
            initialContext.close();
        }
        finally {
            JNDI_DATASOURCES_BACKUP.clear();
        }
    }

    static Map<String, javax.sql.DataSource> getJndiAndSpringDataSources() throws NamingException {
        LinkedHashMap<String, javax.sql.DataSource> dataSources;
        try {
            dataSources = new LinkedHashMap<String, javax.sql.DataSource>(JdbcWrapperHelper.getJndiDataSources());
        }
        catch (NoInitialContextException e) {
            dataSources = new LinkedHashMap();
        }
        dataSources.putAll(SPRING_DATASOURCES);
        return dataSources;
    }

    static Map<String, javax.sql.DataSource> getJndiDataSources() throws NamingException {
        LinkedHashMap<String, javax.sql.DataSource> dataSources = new LinkedHashMap<String, javax.sql.DataSource>(2);
        String datasourcesParameter = Parameter.DATASOURCES.getValue();
        if (datasourcesParameter == null) {
            dataSources.putAll(JdbcWrapperHelper.getJndiDataSourcesAt("java:comp/env/jdbc"));
            dataSources.putAll(JdbcWrapperHelper.getJndiDataSourcesAt("java:/jdbc"));
            dataSources.putAll(JdbcWrapperHelper.getJndiDataSourcesAt("java:global/jdbc"));
            dataSources.putAll(JdbcWrapperHelper.getJndiDataSourcesAt("jdbc"));
        } else if (!datasourcesParameter.trim().isEmpty()) {
            InitialContext initialContext = new InitialContext();
            for (String datasource : datasourcesParameter.split(",")) {
                String jndiName = datasource.trim();
                javax.sql.DataSource dataSource = (javax.sql.DataSource)initialContext.lookup(jndiName);
                dataSources.put(jndiName, dataSource);
            }
            initialContext.close();
        }
        return Collections.unmodifiableMap(dataSources);
    }

    private static Map<String, javax.sql.DataSource> getJndiDataSourcesAt(String jndiPrefix) throws NamingException {
        InitialContext initialContext = new InitialContext();
        LinkedHashMap<String, javax.sql.DataSource> dataSources = new LinkedHashMap<String, javax.sql.DataSource>(2);
        try {
            for (NameClassPair nameClassPair : Collections.list(initialContext.list(jndiPrefix))) {
                Object jndiName = nameClassPair.getName().startsWith("java:") ? nameClassPair.getName() : jndiPrefix + "/" + nameClassPair.getName();
                Object value = initialContext.lookup((String)jndiName);
                if (!(value instanceof javax.sql.DataSource)) continue;
                dataSources.put((String)jndiName, (javax.sql.DataSource)value);
            }
        }
        catch (NamingException e) {
            return dataSources;
        }
        initialContext.close();
        return dataSources;
    }

    static int getMaxConnectionCount() {
        if (!TOMCAT_BASIC_DATASOURCES_PROPERTIES.isEmpty()) {
            return TOMCAT_BASIC_DATASOURCES_PROPERTIES.getMaxActive();
        }
        if (!DBCP_BASIC_DATASOURCES_PROPERTIES.isEmpty()) {
            return DBCP_BASIC_DATASOURCES_PROPERTIES.getMaxActive();
        }
        if (!TOMCAT_JDBC_DATASOURCES_PROPERTIES.isEmpty()) {
            return TOMCAT_JDBC_DATASOURCES_PROPERTIES.getMaxActive();
        }
        return -1;
    }

    static Map<String, Map<String, Object>> getBasicDataSourceProperties() {
        if (!TOMCAT_BASIC_DATASOURCES_PROPERTIES.isEmpty()) {
            return TOMCAT_BASIC_DATASOURCES_PROPERTIES.getDataSourcesProperties();
        }
        if (!DBCP_BASIC_DATASOURCES_PROPERTIES.isEmpty()) {
            return DBCP_BASIC_DATASOURCES_PROPERTIES.getDataSourcesProperties();
        }
        if (!TOMCAT_JDBC_DATASOURCES_PROPERTIES.isEmpty()) {
            return TOMCAT_JDBC_DATASOURCES_PROPERTIES.getDataSourcesProperties();
        }
        return Collections.emptyMap();
    }

    static void pullDataSourceProperties(String name, javax.sql.DataSource dataSource) {
        String dataSourceClassName = dataSource.getClass().getName();
        if ("org.apache.tomcat.dbcp.dbcp2.BasicDataSource".equals(dataSourceClassName) && dataSource instanceof org.apache.tomcat.dbcp.dbcp2.BasicDataSource) {
            JdbcWrapperHelper.pullTomcatDbcp2DataSourceProperties(name, dataSource);
        } else if ("org.apache.commons.dbcp2.BasicDataSource".equals(dataSourceClassName) && dataSource instanceof BasicDataSource) {
            JdbcWrapperHelper.pullCommonsDbcp2DataSourceProperties(name, dataSource);
        } else if ("org.apache.tomcat.jdbc.pool.DataSource".equals(dataSourceClassName) && dataSource instanceof DataSource) {
            JdbcWrapperHelper.pullTomcatJdbcDataSourceProperties(name, dataSource);
        }
    }

    private static void pullTomcatDbcp2DataSourceProperties(String name, javax.sql.DataSource dataSource) {
        org.apache.tomcat.dbcp.dbcp2.BasicDataSource tomcatDbcp2DataSource = (org.apache.tomcat.dbcp.dbcp2.BasicDataSource)dataSource;
        BasicDataSourcesProperties properties = TOMCAT_BASIC_DATASOURCES_PROPERTIES;
        properties.put(name, MAX_ACTIVE_PROPERTY_NAME, tomcatDbcp2DataSource.getMaxTotal());
        properties.put(name, "poolPreparedStatements", tomcatDbcp2DataSource.isPoolPreparedStatements());
        properties.put(name, "defaultCatalog", tomcatDbcp2DataSource.getDefaultCatalog());
        properties.put(name, "defaultAutoCommit", tomcatDbcp2DataSource.getDefaultAutoCommit());
        properties.put(name, "defaultReadOnly", tomcatDbcp2DataSource.getDefaultReadOnly());
        properties.put(name, "defaultTransactionIsolation", tomcatDbcp2DataSource.getDefaultTransactionIsolation());
        properties.put(name, "driverClassName", tomcatDbcp2DataSource.getDriverClassName());
        properties.put(name, "initialSize", tomcatDbcp2DataSource.getInitialSize());
        properties.put(name, "maxIdle", tomcatDbcp2DataSource.getMaxIdle());
        properties.put(name, "maxOpenPreparedStatements", tomcatDbcp2DataSource.getMaxOpenPreparedStatements());
        properties.put(name, "maxWait", tomcatDbcp2DataSource.getMaxWaitMillis());
        properties.put(name, "minEvictableIdleTimeMillis", tomcatDbcp2DataSource.getMinEvictableIdleTimeMillis());
        properties.put(name, "minIdle", tomcatDbcp2DataSource.getMinIdle());
        properties.put(name, "numTestsPerEvictionRun", tomcatDbcp2DataSource.getNumTestsPerEvictionRun());
        properties.put(name, "testOnBorrow", tomcatDbcp2DataSource.getTestOnBorrow());
        properties.put(name, "testOnReturn", tomcatDbcp2DataSource.getTestOnReturn());
        properties.put(name, "testWhileIdle", tomcatDbcp2DataSource.getTestWhileIdle());
        properties.put(name, "timeBetweenEvictionRunsMillis", tomcatDbcp2DataSource.getTimeBetweenEvictionRunsMillis());
        properties.put(name, "validationQuery", tomcatDbcp2DataSource.getValidationQuery());
    }

    private static void pullCommonsDbcp2DataSourceProperties(String name, javax.sql.DataSource dataSource) {
        BasicDataSource dbcp2DataSource = (BasicDataSource)dataSource;
        BasicDataSourcesProperties properties = DBCP_BASIC_DATASOURCES_PROPERTIES;
        properties.put(name, MAX_ACTIVE_PROPERTY_NAME, dbcp2DataSource.getMaxTotal());
        properties.put(name, "poolPreparedStatements", dbcp2DataSource.isPoolPreparedStatements());
        properties.put(name, "defaultCatalog", dbcp2DataSource.getDefaultCatalog());
        properties.put(name, "defaultAutoCommit", dbcp2DataSource.getDefaultAutoCommit());
        properties.put(name, "defaultReadOnly", dbcp2DataSource.getDefaultReadOnly());
        properties.put(name, "defaultTransactionIsolation", dbcp2DataSource.getDefaultTransactionIsolation());
        properties.put(name, "driverClassName", dbcp2DataSource.getDriverClassName());
        properties.put(name, "initialSize", dbcp2DataSource.getInitialSize());
        properties.put(name, "maxIdle", dbcp2DataSource.getMaxIdle());
        properties.put(name, "maxOpenPreparedStatements", dbcp2DataSource.getMaxOpenPreparedStatements());
        properties.put(name, "maxWait", dbcp2DataSource.getMaxWaitMillis());
        properties.put(name, "minEvictableIdleTimeMillis", dbcp2DataSource.getMinEvictableIdleTimeMillis());
        properties.put(name, "minIdle", dbcp2DataSource.getMinIdle());
        properties.put(name, "numTestsPerEvictionRun", dbcp2DataSource.getNumTestsPerEvictionRun());
        properties.put(name, "testOnBorrow", dbcp2DataSource.getTestOnBorrow());
        properties.put(name, "testOnReturn", dbcp2DataSource.getTestOnReturn());
        properties.put(name, "testWhileIdle", dbcp2DataSource.getTestWhileIdle());
        properties.put(name, "timeBetweenEvictionRunsMillis", dbcp2DataSource.getTimeBetweenEvictionRunsMillis());
        properties.put(name, "validationQuery", dbcp2DataSource.getValidationQuery());
    }

    private static void pullTomcatJdbcDataSourceProperties(String name, javax.sql.DataSource dataSource) {
        DataSource jdbcDataSource = (DataSource)dataSource;
        BasicDataSourcesProperties properties = TOMCAT_JDBC_DATASOURCES_PROPERTIES;
        properties.put(name, MAX_ACTIVE_PROPERTY_NAME, jdbcDataSource.getMaxActive());
        properties.put(name, "defaultCatalog", jdbcDataSource.getDefaultCatalog());
        properties.put(name, "defaultAutoCommit", jdbcDataSource.getDefaultAutoCommit());
        properties.put(name, "defaultReadOnly", jdbcDataSource.getDefaultReadOnly());
        properties.put(name, "defaultTransactionIsolation", jdbcDataSource.getDefaultTransactionIsolation());
        properties.put(name, "driverClassName", jdbcDataSource.getDriverClassName());
        properties.put(name, "connectionProperties", jdbcDataSource.getConnectionProperties());
        properties.put(name, "initSQL", jdbcDataSource.getInitSQL());
        properties.put(name, "initialSize", jdbcDataSource.getInitialSize());
        properties.put(name, "maxIdle", jdbcDataSource.getMaxIdle());
        properties.put(name, "maxWait", jdbcDataSource.getMaxWait());
        properties.put(name, "maxAge", jdbcDataSource.getMaxAge());
        properties.put(name, "faireQueue", jdbcDataSource.isFairQueue());
        properties.put(name, "jmxEnabled", jdbcDataSource.isJmxEnabled());
        properties.put(name, "minEvictableIdleTimeMillis", jdbcDataSource.getMinEvictableIdleTimeMillis());
        properties.put(name, "minIdle", jdbcDataSource.getMinIdle());
        properties.put(name, "numTestsPerEvictionRun", jdbcDataSource.getNumTestsPerEvictionRun());
        properties.put(name, "testOnBorrow", jdbcDataSource.isTestOnBorrow());
        properties.put(name, "testOnConnect", jdbcDataSource.isTestOnConnect());
        properties.put(name, "testOnReturn", jdbcDataSource.isTestOnReturn());
        properties.put(name, "testWhileIdle", jdbcDataSource.isTestWhileIdle());
        properties.put(name, "timeBetweenEvictionRunsMillis", jdbcDataSource.getTimeBetweenEvictionRunsMillis());
        properties.put(name, "validationInterval", jdbcDataSource.getValidationInterval());
        properties.put(name, "validationQuery", jdbcDataSource.getValidationQuery());
        properties.put(name, "validatorClassName", jdbcDataSource.getValidatorClassName());
    }

    private static Object changeContextWritable(ServletContext servletContext, Object lock) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException, NamingException {
        assert (servletContext != null);
        String serverInfo = servletContext.getServerInfo();
        if (serverInfo.contains("jetty")) {
            Context jdbcContext = (Context)new InitialContext().lookup("java:comp");
            Field field = JdbcWrapperHelper.getAccessibleField(jdbcContext, "_env");
            Hashtable env = (Hashtable)field.get(jdbcContext);
            if (lock == null) {
                Object result = env.remove("org.mortbay.jndi.lock");
                if (result == null) {
                    result = env.remove("org.eclipse.jndi.lock");
                }
                return result;
            }
            env.put("org.mortbay.jndi.lock", lock);
            env.put("org.eclipse.jndi.lock", lock);
            return null;
        }
        try {
            Field field = Class.forName("org.apache.naming.ContextAccessController").getDeclaredField("readOnlyContexts");
            JdbcWrapperHelper.setFieldAccessible(field);
            Map readOnlyContexts = (Map)field.get(null);
            if (lock == null) {
                Hashtable clone = new Hashtable(readOnlyContexts);
                readOnlyContexts.clear();
                return clone;
            }
            Hashtable myLock = (Hashtable)lock;
            readOnlyContexts.putAll(myLock);
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static Object getFieldValue(Object object, String fieldName) throws IllegalAccessException {
        return JdbcWrapperHelper.getAccessibleField(object, fieldName).get(object);
    }

    static void setFieldValue(Object object, String fieldName, Object value) throws IllegalAccessException {
        JdbcWrapperHelper.getAccessibleField(object, fieldName).set(object, value);
    }

    static boolean hasField(Object object, String fieldName) {
        return JdbcWrapperHelper.getField(object, fieldName) != null;
    }

    private static Field getAccessibleField(Object object, String fieldName) {
        Field result = JdbcWrapperHelper.getField(object, fieldName);
        assert (result != null);
        JdbcWrapperHelper.setFieldAccessible(result);
        return result;
    }

    private static Field getField(Object object, String fieldName) {
        assert (fieldName != null);
        Class<?> classe = object.getClass();
        Field result = null;
        do {
            for (Field field : classe.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                result = field;
                break;
            }
            classe = classe.getSuperclass();
        } while (result == null && classe != null);
        return result;
    }

    private static void setFieldAccessible(Field field) {
        field.setAccessible(true);
    }

    static void clearProxyCache() {
        PROXY_CACHE.clear();
    }

    static <T> T createProxy(T object, InvocationHandler invocationHandler, List<Class<?>> interfaces) {
        Class<?> objectClass = object.getClass();
        Constructor<?> constructor = PROXY_CACHE.get(objectClass);
        if (constructor == null) {
            Class<?>[] interfacesArray = JdbcWrapperHelper.getObjectInterfaces(objectClass, interfaces);
            constructor = JdbcWrapperHelper.getProxyConstructor(objectClass, interfacesArray);
            if (interfaces == null) {
                PROXY_CACHE.put(objectClass, constructor);
            }
        }
        try {
            return (T)constructor.newInstance(invocationHandler);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Constructor<?> getProxyConstructor(Class<?> objectClass, Class<?>[] interfacesArray) {
        ClassLoader classLoader = objectClass.getClassLoader();
        try {
            Constructor<?> constructor = Proxy.getProxyClass(classLoader, interfacesArray).getConstructor(InvocationHandler.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Class<?>[] getObjectInterfaces(Class<?> objectClass, List<Class<?>> interfaces) {
        List<Class<Class<?>>> myInterfaces;
        if (interfaces == null) {
            myInterfaces = new ArrayList(List.of(objectClass.getInterfaces()));
            for (Class<?> classe = objectClass.getSuperclass(); classe != null; classe = classe.getSuperclass()) {
                Class<?>[] classInterfaces = classe.getInterfaces();
                if (classInterfaces.length <= 0) continue;
                List<Class<?>> superInterfaces = List.of(classInterfaces);
                myInterfaces.removeAll(superInterfaces);
                myInterfaces.addAll(superInterfaces);
            }
            myInterfaces.remove(Referenceable.class);
        } else {
            myInterfaces = interfaces;
        }
        return myInterfaces.toArray(new Class[0]);
    }

    private static class BasicDataSourcesProperties {
        private final Map<String, Map<String, Object>> properties = new LinkedHashMap<String, Map<String, Object>>();

        BasicDataSourcesProperties() {
        }

        boolean isEmpty() {
            return this.properties.isEmpty();
        }

        int getMaxActive() {
            int result = 0;
            for (Map<String, Object> dataSourceProperties : this.properties.values()) {
                Integer maxActive = (Integer)dataSourceProperties.get(JdbcWrapperHelper.MAX_ACTIVE_PROPERTY_NAME);
                if (maxActive == null) {
                    return -1;
                }
                result += maxActive.intValue();
            }
            return result;
        }

        Map<String, Map<String, Object>> getDataSourcesProperties() {
            LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Map<String, Object>> entry : this.properties.entrySet()) {
                result.put(entry.getKey(), Collections.unmodifiableMap(entry.getValue()));
            }
            return Collections.unmodifiableMap(result);
        }

        void put(String dataSourceName, String key, Object value) {
            Map dataSourceProperties = this.properties.computeIfAbsent(dataSourceName, k -> new LinkedHashMap());
            dataSourceProperties.put(key, value);
        }
    }
}

