/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;

public class SpringElasticsearchOperationsBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private static final boolean ELASTICSEARCH_OPERATIONS_AVAILABLE = SpringElasticsearchOperationsBeanPostProcessor.isElasticsearchOperationsAvailable();
    private static final Counter SERVICES_COUNTER = MonitoringProxy.getServicesCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(SERVICES_COUNTER.getName());
    private static final boolean DISABLED = Parameter.DISABLED.getValueAsBoolean();
    private int order = Integer.MAX_VALUE;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (ELASTICSEARCH_OPERATIONS_AVAILABLE && bean instanceof ElasticsearchOperations) {
            final ElasticsearchOperations elasticsearchOperations = (ElasticsearchOperations)bean;
            if (DISABLED) {
                return elasticsearchOperations;
            }
            SERVICES_COUNTER.setDisplayed(!COUNTER_HIDDEN);
            SERVICES_COUNTER.setUsed(true);
            InvocationHandler invocationHandler = new InvocationHandler(){
                final /* synthetic */ SpringElasticsearchOperationsBeanPostProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    StringBuilder requestName = new StringBuilder();
                    requestName.append("elasticsearch.").append(method.getName()).append('(');
                    if (args != null) {
                        boolean first = true;
                        for (Object arg : args) {
                            if (first) {
                                first = false;
                            } else {
                                requestName.append(", ");
                            }
                            if (arg == null) {
                                requestName.append("null");
                                continue;
                            }
                            if (arg instanceof Class) {
                                requestName.append(((Class)arg).getSimpleName());
                                continue;
                            }
                            requestName.append(arg.getClass().getSimpleName());
                        }
                    }
                    requestName.append(')');
                    return SpringElasticsearchOperationsBeanPostProcessor.doInvoke(elasticsearchOperations, method, args, requestName.toString());
                }
            };
            ElasticsearchOperations ops = JdbcWrapper.createProxy(elasticsearchOperations, invocationHandler);
            LOG.debug("elasticsearch operations monitoring initialized");
            return ops;
        }
        return bean;
    }

    static Object doInvoke(Object object, Method method, Object[] args, String requestName) throws Throwable {
        boolean systemError = false;
        try {
            SERVICES_COUNTER.bindContextIncludingCpu(requestName);
            Object object2 = method.invoke(object, args);
            return object2;
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            SERVICES_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    private static boolean isElasticsearchOperationsAvailable() {
        try {
            Class.forName("org.springframework.data.elasticsearch.core.ElasticsearchOperations");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

