/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.internal.common.LOG;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.management.CacheStatistics;

public class CacheInformations
implements Serializable {
    private static final long serialVersionUID = -3025833425994923286L;
    private static final boolean EHCACHE_AVAILABLE = CacheInformations.isEhcacheAvailable();
    private final String name;
    private final long inMemoryObjectCount;
    private final int inMemoryPercentUsed;
    private final long onDiskObjectCount;
    private final long inMemoryHits;
    private final long cacheHits;
    private final long cacheMisses;
    private final String configuration;
    private final List<?> cacheKeys;

    CacheInformations(Ehcache cache, boolean includeKeys) {
        assert (cache != null);
        this.name = cache.getName();
        this.cacheKeys = includeKeys ? cache.getKeys() : null;
        CacheStatistics statistics = new CacheStatistics(cache);
        this.inMemoryObjectCount = statistics.getMemoryStoreObjectCount();
        this.onDiskObjectCount = statistics.getDiskStoreObjectCount();
        this.inMemoryHits = statistics.getInMemoryHits();
        this.cacheHits = statistics.getCacheHits();
        this.cacheMisses = statistics.getCacheMisses();
        this.inMemoryPercentUsed = this.computeMemoryPercentUsed(cache);
        this.configuration = this.buildConfiguration(cache);
    }

    private static boolean isEhcacheAvailable() {
        try {
            Class.forName("net.sf.ehcache.Cache");
            Class.forName("net.sf.ehcache.statistics.StatisticsGateway");
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    static List<CacheInformations> buildCacheInformationsList() {
        ArrayList allCacheManagers;
        if (!EHCACHE_AVAILABLE) {
            return Collections.emptyList();
        }
        try {
            allCacheManagers = new ArrayList(CacheManager.ALL_CACHE_MANAGERS);
        }
        catch (NoSuchFieldError e) {
            return Collections.emptyList();
        }
        ArrayList<CacheInformations> result = new ArrayList<CacheInformations>();
        for (CacheManager cacheManager : allCacheManagers) {
            String[] cacheNames = cacheManager.getCacheNames();
            try {
                for (String cacheName : cacheNames) {
                    result.add(new CacheInformations(cacheManager.getEhcache(cacheName), false));
                }
            }
            catch (Exception e) {
                LOG.debug(e.toString(), e);
            }
        }
        return result;
    }

    public static CacheInformations buildCacheInformationsWithKeys(String cacheId) {
        assert (EHCACHE_AVAILABLE);
        assert (cacheId != null);
        ArrayList allCacheManagers = new ArrayList(CacheManager.ALL_CACHE_MANAGERS);
        for (CacheManager cacheManager : allCacheManagers) {
            Ehcache ehcache = cacheManager.getEhcache(cacheId);
            if (ehcache == null) continue;
            return new CacheInformations(ehcache, true);
        }
        throw new IllegalArgumentException("Cache not found");
    }

    private int computeMemoryPercentUsed(Object cache) {
        long maxElementsInMemory = ((Ehcache)cache).getCacheConfiguration().getMaxEntriesLocalHeap();
        if (maxElementsInMemory == 0L) {
            return -1;
        }
        return (int)(100L * this.inMemoryObjectCount / maxElementsInMemory);
    }

    private String buildConfiguration(Object cache) {
        StringBuilder sb = new StringBuilder();
        CacheConfiguration config = ((Ehcache)cache).getCacheConfiguration();
        sb.append("ehcache [maxEntriesLocalHeap = ").append(config.getMaxEntriesLocalHeap());
        boolean overflowToDisk = config.isOverflowToDisk();
        sb.append(", overflowToDisk = ").append(overflowToDisk);
        if (overflowToDisk) {
            sb.append(", maxEntriesLocalDisk = ").append(config.getMaxEntriesLocalDisk());
        }
        boolean eternal = config.isEternal();
        sb.append(", eternal = ").append(eternal);
        if (!eternal) {
            sb.append(", timeToLiveSeconds = ").append(config.getTimeToLiveSeconds());
            sb.append(", timeToIdleSeconds = ").append(config.getTimeToIdleSeconds());
            sb.append(", memoryStoreEvictionPolicy = ").append(config.getMemoryStoreEvictionPolicy());
        }
        sb.append(", diskPersistent = ").append(config.isDiskPersistent());
        sb.append(']');
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public long getInMemoryObjectCount() {
        return this.inMemoryObjectCount;
    }

    public long getInMemoryPercentUsed() {
        return this.inMemoryPercentUsed;
    }

    public long getOnDiskObjectCount() {
        return this.onDiskObjectCount;
    }

    public long getInMemoryHits() {
        return this.inMemoryHits;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public int getInMemoryHitsRatio() {
        if (this.cacheHits == 0L) {
            return -1;
        }
        return (int)(100L * this.inMemoryHits / this.cacheHits);
    }

    public int getHitsRatio() {
        long accessCount = this.cacheHits + this.cacheMisses;
        if (accessCount == 0L) {
            return -1;
        }
        return (int)(100L * this.cacheHits / accessCount);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public List<?> getCacheKeys() {
        return this.cacheKeys;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", inMemoryObjectCount=" + this.getInMemoryObjectCount() + ", inMemoryPercentUsed=" + this.getInMemoryPercentUsed() + ", onDiskObjectCount=" + this.getOnDiskObjectCount() + ", inMemoryHitsRatio=" + this.getInMemoryHitsRatio() + ", hitsRatio=" + this.getHitsRatio() + "]";
    }
}

