/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.Parameter;

public class ConnectionInformations
implements Serializable {
    private static final long serialVersionUID = -6063966419161604125L;
    private static final String OWN_PACKAGE = ConnectionInformations.class.getName().substring(0, ConnectionInformations.class.getName().lastIndexOf(46));
    private static final boolean CONNECTIONS_STACK_TRACES_DISABLED = Parameter.CONNECTIONS_STACK_TRACES_DISABLED.getValueAsBoolean();
    private final long openingTime = System.currentTimeMillis();
    private final StackTraceElement[] openingStackTrace;
    private final long threadId;

    public ConnectionInformations() {
        Thread currentThread = Thread.currentThread();
        this.openingStackTrace = CONNECTIONS_STACK_TRACES_DISABLED ? null : currentThread.getStackTrace();
        this.threadId = currentThread.getId();
    }

    public static int getUniqueIdOfConnection(Connection connection) {
        return System.identityHashCode(connection);
    }

    public Date getOpeningDate() {
        return new Date(this.openingTime);
    }

    public List<StackTraceElement> getOpeningStackTrace() {
        if (this.openingStackTrace == null) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>(List.of(this.openingStackTrace));
        do {
            stackTrace.remove(0);
        } while (((StackTraceElement)stackTrace.get(0)).getClassName().startsWith(OWN_PACKAGE));
        return stackTrace;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[openingDate=" + String.valueOf(this.getOpeningDate()) + ", threadId=" + this.getThreadId() + "]";
    }
}

