/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.jrobin.core.RrdFileBackend;

public class RrdFfmBackend
extends RrdFileBackend {
    private static Timer fileSyncTimer;
    private Arena arena;
    private MemorySegment memorySegment;
    private final TimerTask syncTask = new TimerTask(){

        @Override
        public void run() {
            RrdFfmBackend.this.sync();
        }
    };

    protected RrdFfmBackend(String path, boolean readOnly, int syncPeriod) throws IOException {
        super(path, readOnly);
        try {
            this.mapFile();
            if (!readOnly) {
                fileSyncTimer.schedule(this.syncTask, (long)syncPeriod * 1000L, (long)syncPeriod * 1000L);
            }
        }
        catch (IOException ioe) {
            super.close();
            throw ioe;
        }
        catch (IllegalStateException e) {
            this.unmapFile();
            super.close();
            throw e;
        }
    }

    public static Timer getFileSyncTimer() {
        return fileSyncTimer;
    }

    public static void setFileSyncTimer(Timer timer) {
        fileSyncTimer = timer;
    }

    private void mapFile() throws IOException {
        long length = this.getLength();
        if (length > 0L) {
            FileChannel.MapMode mapMode = FileChannel.MapMode.READ_WRITE;
            this.arena = Arena.ofShared();
            this.memorySegment = this.file.getChannel().map(mapMode, 0L, length, this.arena);
        }
    }

    private void unmapFile() {
        if (this.arena != null) {
            this.arena.close();
            this.arena = null;
            this.memorySegment = null;
        }
    }

    protected synchronized void setLength(long newLength) throws IOException {
        this.unmapFile();
        super.setLength(newLength);
        this.mapFile();
    }

    protected synchronized void write(long offset, byte[] b) throws IOException {
        if (this.memorySegment == null) {
            throw new IOException("Write failed, file " + this.getPath() + " not mapped for I/O");
        }
        MemorySegment.copy(b, 0, this.memorySegment, ValueLayout.JAVA_BYTE, offset, b.length);
    }

    protected synchronized void read(long offset, byte[] b) throws IOException {
        if (this.memorySegment == null) {
            throw new IOException("Read failed, file " + this.getPath() + " not mapped for I/O");
        }
        MemorySegment.copy(this.memorySegment, ValueLayout.JAVA_BYTE, offset, b, 0, b.length);
    }

    public synchronized void close() throws IOException {
        try {
            if (this.syncTask != null) {
                this.syncTask.cancel();
            }
            this.sync();
            this.unmapFile();
        }
        finally {
            super.close();
        }
    }

    protected synchronized void sync() {
        if (this.memorySegment != null) {
            this.memorySegment.force();
        }
    }
}

