/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;

class WebappVersions {
    private static final Comparator<Map.Entry<String, Date>> WEBAPP_VERSIONS_VALUE_COMPARATOR = new MapValueComparator().reversed();
    private static final String VERSIONS_FILENAME = "versions.properties";
    private static final String VERSIONS_DATE_PATTERN = "yyyy/MM/dd";
    private final Map<String, Date> datesByVersions;
    private final File versionsFile;

    WebappVersions(String application) {
        assert (application != null);
        File storageDirectory = Parameters.getStorageDirectory(application);
        this.versionsFile = new File(storageDirectory, VERSIONS_FILENAME);
        this.datesByVersions = this.readDatesByVersions();
    }

    private Map<String, Date> readDatesByVersions() {
        HashMap<String, Date> result = new HashMap<String, Date>();
        if (this.versionsFile.exists()) {
            Properties versionsProperties = new Properties();
            try {
                try (FileInputStream input = new FileInputStream(this.versionsFile);){
                    versionsProperties.load(input);
                }
                ArrayList<String> propertyNames = Collections.list(versionsProperties.propertyNames());
                SimpleDateFormat dateFormat = new SimpleDateFormat(VERSIONS_DATE_PATTERN, Locale.US);
                for (String version : propertyNames) {
                    try {
                        Date date = dateFormat.parse(versionsProperties.getProperty(version));
                        result.put(version, date);
                    }
                    catch (ParseException e) {}
                }
            }
            catch (IOException e) {
                LOG.warn("exception while reading versions in " + String.valueOf(this.versionsFile), e);
            }
        }
        return result;
    }

    Map<String, Date> getDatesByVersions() {
        ArrayList<Map.Entry<String, Date>> entries = new ArrayList<Map.Entry<String, Date>>(this.datesByVersions.entrySet());
        entries.sort(WEBAPP_VERSIONS_VALUE_COMPARATOR);
        LinkedHashMap<String, Date> map = new LinkedHashMap<String, Date>();
        for (Map.Entry entry : entries) {
            map.put((String)entry.getKey(), (Date)entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    void addVersionIfNeeded(String webappVersion) throws IOException {
        if (webappVersion == null || this.datesByVersions.containsKey(webappVersion)) {
            return;
        }
        Properties versionsProperties = new Properties();
        if (this.versionsFile.exists()) {
            try (FileInputStream input = new FileInputStream(this.versionsFile);){
                versionsProperties.load(input);
            }
        }
        assert (versionsProperties.getProperty(webappVersion) == null);
        SimpleDateFormat dateFormat = new SimpleDateFormat(VERSIONS_DATE_PATTERN, Locale.US);
        versionsProperties.setProperty(webappVersion, dateFormat.format(new Date()));
        File directory = this.versionsFile.getParentFile();
        if (!directory.mkdirs() && !directory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + directory.getPath());
        }
        try (FileOutputStream output = new FileOutputStream(this.versionsFile);){
            versionsProperties.store(output, "Application deployments with versions and dates");
        }
        this.datesByVersions.put(webappVersion, new Date());
        LOG.debug("New application version added: " + webappVersion);
    }

    private static class MapValueComparator<K, V extends Comparable<V>>
    implements Comparator<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        MapValueComparator() {
        }

        @Override
        public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
            return ((Comparable)o1.getValue()).compareTo((Comparable)o2.getValue());
        }
    }
}

