/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.CacheInformations;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.HsErrPid;
import net.bull.javamelody.internal.model.JCacheInformations;
import net.bull.javamelody.internal.model.JRobin;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JobInformations;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.model.ThreadInformations;
import net.bull.javamelody.internal.model.UpdateChecker;
import net.bull.javamelody.internal.model.VirtualMachine;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlCacheInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlCounterReport;
import net.bull.javamelody.internal.web.html.HtmlCounterRequestContextReport;
import net.bull.javamelody.internal.web.html.HtmlForms;
import net.bull.javamelody.internal.web.html.HtmlJCacheInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlJavaInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlJobInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlSourceReport;
import net.bull.javamelody.internal.web.html.HtmlThreadInformationsReport;

class HtmlCoreReport
extends HtmlAbstractReport {
    private static final int MAX_CURRENT_REQUESTS_DISPLAYED_IN_MAIN_REPORT = 500;
    private static final int MAX_THREADS_DISPLAYED_IN_MAIN_REPORT = 500;
    private static final String SEPARATOR = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String END_DIV = "</div>";
    private final Collector collector;
    private final List<JavaInformations> javaInformationsList;
    private final Range range;
    private final CollectorServer collectorServer;
    private final long start = System.currentTimeMillis();
    private final Map<String, String> menuTextsByAnchorName = new LinkedHashMap<String, String>();

    HtmlCoreReport(Collector collector, CollectorServer collectorServer, List<JavaInformations> javaInformationsList, Range range, Writer writer) {
        super(writer);
        assert (collector != null);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (range != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.javaInformationsList = javaInformationsList;
        this.range = range;
    }

    @Override
    void toHtml() throws IOException {
        this.toHtml(null, null);
    }

    void toHtml(String message, String anchorNameForRedirect) throws IOException {
        this.writeAlerts();
        if (this.collectorServer != null) {
            this.writeApplicationsLinks();
        }
        this.writeln("<h3 class='chapterTitle'><img src='?resource=systemmonitor.png' alt='#Stats#'/>");
        this.writeAnchor("top", I18N.getString("Stats"));
        this.writeSummary();
        this.writeln("</h3>");
        this.write("<a class='donate' href='https://github.com/javamelody/javamelody/wiki/Donate'>");
        this.writeln("<img class='noPrint' src='?resource=donate.gif' alt='Donate' /></a>");
        this.writeln("<div align='center'>");
        this.writeRefreshAndPeriodLinks(null, null);
        this.writeGraphs();
        this.writeln(END_DIV);
        List<Counter> counters = this.collector.getRangeCountersToBeDisplayed(this.range);
        Map<String, HtmlCounterReport> counterReportsByCounterName = this.writeCounters(counters);
        if (this.collectorServer == null) {
            this.writeln("<h3 class='chapterTitle'><img src='?resource=hourglass.png' alt='#Requetes_en_cours#'/>");
            this.writeAnchor("currentRequests", I18N.getString("Requetes_en_cours"));
            this.writeln("#Requetes_en_cours#</h3>");
            this.writeCurrentRequests(this.javaInformationsList.get(0), counters, counterReportsByCounterName);
        }
        this.writeln("<h3 class='chapterTitle'><img src='?resource=systeminfo.png' alt='#Informations_systemes#'/>");
        this.writeAnchor("systeminfo", I18N.getString("Informations_systemes"));
        this.writeln("#Informations_systemes#</h3>");
        if (this.collectorServer != null) {
            this.writeln("<div align='center' class='noPrint'><a href='?part=currentRequests'>");
            this.writeln("<img src='?resource=hourglass.png' width='20' height='20' alt=\"#Voir_requetes_en_cours#\" /> #Voir_requetes_en_cours#</a>");
            this.writeln(END_DIV);
            this.writeln("<br/>");
        }
        if (Parameters.isSystemActionsEnabled()) {
            this.writeSystemActionsLinks();
        }
        new HtmlJavaInformationsReport(this.javaInformationsList, this.getWriter()).toHtml();
        this.writeln("<h3 class='chapterTitle'><img src='?resource=threads.png' alt='#Threads#'/>");
        this.writeAnchor("threads", I18N.getString("Threads"));
        this.writeln("#Threads#</h3>");
        this.writeThreads();
        if (this.isJobEnabled()) {
            this.writeln("<h3 class='chapterTitle'><img src='?resource=jobs.png' alt='#Jobs#'/>");
            this.writeAnchor("jobs", I18N.getString("Jobs"));
            this.writeln("#Jobs#</h3>");
            this.writeJobs(this.collector.getRangeCounter(this.range, "job"));
        }
        if (this.isCacheEnabled()) {
            this.writeln("<h3 class='chapterTitle'><img src='?resource=caches.png' alt='#Caches#'/>");
            this.writeAnchor("caches", I18N.getString("Caches"));
            this.writeln("#Caches#</h3>");
            this.writeCaches();
        }
        if (this.isJCacheEnabled()) {
            this.writeln("<h3 class='chapterTitle'><img src='?resource=caches.png' alt='#Caches#'/>");
            this.writeAnchor("caches", I18N.getString("Caches"));
            this.writeln("#Caches#</h3>");
            this.writeJCaches();
        }
        this.writeMenu();
        this.writeMessageIfNotNull(message, null, anchorNameForRedirect);
        this.writeDurationAndOverhead();
    }

    private void writeAlerts() throws IOException {
        Throwable lastCollectorException;
        String newJavamelodyVersion = UpdateChecker.getNewJavamelodyVersion();
        if (newJavamelodyVersion != null) {
            this.writeln("<div class='newVersion' align='center'>");
            this.writeln("<img src='?resource=alert.png' alt='alert'/>");
            this.writeDirectly(I18N.getFormattedString("version_alert", newJavamelodyVersion, Parameters.JAVAMELODY_VERSION));
            this.writeln(END_DIV);
        }
        if ((lastCollectorException = this.collector.getLastCollectorException()) != null) {
            this.writeln("<div class='alert'>");
            this.writeln("<img src='?resource=alert.png' alt='alert'/>");
            this.writeDirectly(HtmlCoreReport.htmlEncodeButNotSpace(lastCollectorException.toString()));
            this.writeln(END_DIV);
            this.writeShowHideLink("detailsLastCollectorException", "#Details#");
            this.writeln("<div id='detailsLastCollectorException' class='displayNone'><div>");
            StringWriter stackTraceWriter = new StringWriter(200);
            lastCollectorException.printStackTrace(new PrintWriter(stackTraceWriter));
            for (String stackTraceElement : stackTraceWriter.toString().split("[\n\r]")) {
                if (stackTraceElement.isEmpty()) continue;
                this.writeDirectly(HtmlSourceReport.htmlEncodeStackTraceElementAndTabs(stackTraceElement));
                this.writeDirectly("<br/>\n");
            }
            this.writeln("</div></div>");
        }
        if (this.collectorServer != null && this.collectorServer.isApplicationDataAvailable(this.collector.getApplication()) && this.javaInformationsList.size() < this.collectorServer.getUrlsByApplication(this.collector.getApplication()).size()) {
            this.writeln("<div class='alert'>");
            this.writeln("<img src='?resource=alert.png' alt='alert'/> #some_node_unavailable#");
            this.writeln("</div><br/>");
        }
    }

    private void writeSummary() throws IOException {
        String javaMelodyUrl = "<a href='https://github.com/javamelody/javamelody/wiki' target='_blank'>JavaMelody</a>";
        if (this.range.getPeriod() == Period.TOUT) {
            String startDate = I18N.createDateAndTimeFormat().format(this.collector.getCounters().get(0).getStartDate());
            this.writeDirectly(HtmlCoreReport.getFormattedString("Statistiques", "<a href='https://github.com/javamelody/javamelody/wiki' target='_blank'>JavaMelody</a>", I18N.getCurrentDateAndTime(), startDate, this.collector.getApplication()));
        } else {
            this.writeDirectly(HtmlCoreReport.getFormattedString("Statistiques_sans_depuis", "<a href='https://github.com/javamelody/javamelody/wiki' target='_blank'>JavaMelody</a>", I18N.getCurrentDateAndTime(), this.collector.getApplication()));
        }
        String contextDisplayName = this.javaInformationsList.get(0).getContextDisplayName();
        String webappVersion = this.javaInformationsList.get(0).getWebappVersion();
        if (contextDisplayName != null) {
            this.writeDirectly(" (");
            this.writeDirectly(HtmlCoreReport.htmlEncodeButNotSpace(contextDisplayName));
            if (webappVersion != null) {
                this.writeDirectly(", " + HtmlCoreReport.htmlEncodeButNotSpace(webappVersion));
            }
            this.writeDirectly(")");
        } else if (webappVersion != null) {
            this.writeDirectly(" (");
            this.writeDirectly(HtmlCoreReport.htmlEncodeButNotSpace(webappVersion));
            this.writeDirectly(")");
        }
        this.writeln("");
    }

    private void writeAnchor(String anchorName, String menuText) throws IOException {
        this.write("<a name='" + anchorName + "'></a>");
        this.menuTextsByAnchorName.put(anchorName, menuText);
    }

    private void writeMenu() throws IOException {
        this.writeln("<div class='noPrint'> ");
        this.writeln("<div id='menuBox' class='menuHide'>");
        this.writeln("  <ul id='menuTab'><li><a class='menuBoxToggle'><img id='menuToggle' src='?resource=menu.png' alt='menu' /></a></li></ul>");
        this.writeln("  <div id='menuLinks'><div id='menuDeco'>");
        for (Map.Entry<String, String> entry : this.menuTextsByAnchorName.entrySet()) {
            String anchorName = entry.getKey();
            String menuText = entry.getValue();
            this.writeDirectly("    <div class='menuButton'><a href='#" + anchorName + "'>" + menuText + "</a></div>");
            this.writeln("");
        }
        String customReports = Parameter.CUSTOM_REPORTS.getValue();
        if (customReports != null) {
            for (String customReport : customReports.split(",")) {
                String customReportName = customReport.trim();
                String customReportPath = Parameters.getParameterValueByName(customReportName);
                if (customReportPath == null) {
                    LOG.debug("Parameter not defined in web.xml for custom report: " + customReportName);
                    continue;
                }
                this.writeDirectly("    <div class='menuButton'><a href='?report=" + URLEncoder.encode(customReportName, StandardCharsets.UTF_8) + "'>" + HtmlCoreReport.htmlEncode(customReportName) + "</a></div>");
                this.writeln("");
            }
        }
        if (SessionListener.getCurrentSession() != null) {
            this.writeDirectly("    <div class='menuButton'><a href='?action=logout" + HtmlCoreReport.getCsrfTokenUrlPart() + "'>" + I18N.getString("logout") + "</a></div>");
            this.writeln("");
        }
        this.writeln("  </div></div>");
        this.writeln("</div></div>");
    }

    private Map<String, HtmlCounterReport> writeCounters(List<Counter> counters) throws IOException {
        HashMap<String, HtmlCounterReport> counterReportsByCounterName = new HashMap<String, HtmlCounterReport>();
        for (Counter counter : counters) {
            HtmlCounterReport htmlCounterReport = this.writeCounter(counter);
            counterReportsByCounterName.put(counter.getName(), htmlCounterReport);
        }
        if (this.range.getPeriod() == Period.TOUT && counterReportsByCounterName.size() > 1) {
            this.writeln("<div align='right'>");
            this.writeln("<a href='?action=clear_counter&amp;counter=all" + HtmlCoreReport.getCsrfTokenUrlPart() + "' title='#Vider_toutes_stats#'");
            this.writeln("class='confirm noPrint' data-confirm='" + HtmlCoreReport.htmlEncodeButNotSpaceAndNewLine(HtmlCoreReport.getString("confirm_vider_toutes_stats")) + "'>#Reinitialiser_toutes_stats#</a>");
            this.writeln(END_DIV);
        }
        return counterReportsByCounterName;
    }

    private HtmlCounterReport writeCounter(Counter counter) throws IOException {
        this.writeCounterTitle(counter);
        HtmlCounterReport htmlCounterReport = new HtmlCounterReport(counter, this.range, this.getWriter());
        htmlCounterReport.toHtml();
        return htmlCounterReport;
    }

    private void writeCounterTitle(Counter counter) throws IOException {
        this.writeln("<h3 class='chapterTitle'><img src='?resource=" + counter.getIconName() + "' alt='" + counter.getName() + "'/>");
        this.writeAnchor(counter.getName(), I18N.getString("Stats") + " " + counter.getName().toLowerCase(Locale.ENGLISH));
        String counterLabel = HtmlCoreReport.getString(counter.getName() + "Label");
        this.write(HtmlCoreReport.getFormattedString("Statistiques_compteur", counterLabel));
        this.write(" - " + this.range.getLabel());
        if (this.range.getPeriod() != Period.TOUT) {
            this.write(" #depuis_minuit#");
        }
        this.writeln("</h3>");
    }

    static void writeAddAndRemoveApplicationLinks(String currentApplication, Collection<String> applications, Writer writer) throws IOException {
        new HtmlForms(writer).writeAddAndRemoveApplicationLinks(currentApplication, applications);
    }

    void writeMessageIfNotNull(String message, String partToRedirectTo, String anchorNameForRedirect) throws IOException {
        if (message != null) {
            Object href = partToRedirectTo == null ? (anchorNameForRedirect == null ? "?" : "?#" + anchorNameForRedirect) : "?part=" + partToRedirectTo;
            this.writeDirectly("<span class='alertAndRedirect' data-alert='" + HtmlCoreReport.htmlEncodeButNotSpaceAndNewLine(message) + "' data-href='" + (String)href + "'></span>");
        }
    }

    private void writeGraphs() throws IOException {
        if (this.collector.isStopped()) {
            this.writeln("<div align='center' class='severe'><br/><br/>");
            this.writeln("#collect_server_misusage#");
            this.writeln(END_DIV);
            return;
        }
        if (this.collector.isStorageUsedByMultipleInstances()) {
            this.writeln("<div align='center' class='severe'><br/><br/>");
            this.writeln("#storage_used_by_multiple_instances#");
            this.writeln("</div><br/>");
        }
        this.writeGraphs(this.collector.getDisplayedCounterJRobins(), false);
        Collection<JRobin> otherJRobins = this.collector.getDisplayedOtherJRobins();
        if (!otherJRobins.isEmpty()) {
            this.writeln("<div align='right'>");
            this.writeShowHideLink("detailsGraphs", "#Autres_courbes#");
            this.writeln(END_DIV);
            this.writeln("<div id='detailsGraphs' class='displayNone'><div>");
            this.writeGraphs(otherJRobins, true);
            this.writeln("</div></div>");
        }
    }

    private void writeGraphs(Collection<JRobin> jrobins, boolean lazyGraphs) throws IOException {
        int i = 0;
        for (JRobin jrobin : jrobins) {
            String jrobinName = jrobin.getName();
            this.write("<a href='?part=graph&amp;graph=" + jrobinName + "'><img class='synthese' ");
            if (lazyGraphs) {
                this.write("data-src");
            } else {
                this.write("src");
            }
            this.writeln("='?width=200&amp;height=50&amp;graph=" + jrobinName + "' alt=\"" + jrobin.getLabel() + "\" title=\"" + jrobin.getLabel() + "\"/></a>");
            if (++i % 3 != 0) continue;
            this.writeln("<br/>");
        }
    }

    private void writeCurrentRequests(JavaInformations javaInformations, List<Counter> counters, Map<String, HtmlCounterReport> counterReportsByCounterName) throws IOException {
        List<ThreadInformations> threadInformationsList = javaInformations.getThreadInformationsList();
        boolean stackTraceEnabled = javaInformations.isStackTraceEnabled();
        List<CounterRequestContext> rootCurrentContexts = this.collector.getRootCurrentContexts(counters);
        this.writeCurrentRequests(threadInformationsList, rootCurrentContexts, stackTraceEnabled, 500, false, counterReportsByCounterName);
    }

    void writeAllCurrentRequestsAsPart(Map<JavaInformations, List<CounterRequestContext>> currentRequests) throws IOException {
        this.writeln("<div  class='noPrint'>");
        this.writeln("<a class='back' href=''><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln(SEPARATOR);
        this.writeln("<a href='?part=currentRequests'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlCoreReport.isPdfEnabled()) {
            this.writeln(SEPARATOR);
            this.write("<a href='?part=currentRequests&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("</div><br/>");
        for (Map.Entry<JavaInformations, List<CounterRequestContext>> entry : currentRequests.entrySet()) {
            JavaInformations javaInformations = entry.getKey();
            List<CounterRequestContext> rootCurrentContexts = entry.getValue();
            List<ThreadInformations> threadInformationsList = javaInformations.getThreadInformationsList();
            boolean stackTraceEnabled = javaInformations.isStackTraceEnabled();
            this.writeCurrentRequests(threadInformationsList, rootCurrentContexts, stackTraceEnabled, Integer.MAX_VALUE, true, null);
            this.write("<br/><br/>");
        }
    }

    private void writeCurrentRequests(List<ThreadInformations> threadInformationsList, List<CounterRequestContext> rootCurrentContexts, boolean stackTraceEnabled, int maxContextsDisplayed, boolean onlyTitleAndDetails, Map<String, HtmlCounterReport> counterReportsByCounterName) throws IOException {
        HtmlCounterRequestContextReport htmlCounterRequestContextReport = new HtmlCounterRequestContextReport(rootCurrentContexts, counterReportsByCounterName, threadInformationsList, stackTraceEnabled, maxContextsDisplayed, this.getWriter());
        if (onlyTitleAndDetails) {
            htmlCounterRequestContextReport.writeTitleAndDetails();
        } else {
            htmlCounterRequestContextReport.toHtml();
        }
    }

    void writeAllThreadsAsPart() throws IOException {
        String separator = SEPARATOR;
        this.writeln("<div class='noPrint'>");
        this.writeln("<a class='back' href=''><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln(SEPARATOR);
        this.writeln("<a href='?part=threads'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlCoreReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=threads&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isStackTraceEnabled()) continue;
            this.writeln(SEPARATOR);
            this.writeln("<a href='?part=threadsDump'><img src='?resource=text.png' alt='#Dump_threads_en_texte#'/>&nbsp;#Dump_threads_en_texte#</a>");
            break;
        }
        this.writeln("</div> <br/>");
        this.writeTitle("threads.png", HtmlCoreReport.getString("Threads"));
        this.write(" <br/>");
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.write(" <b>");
            this.writeDirectly(HtmlCoreReport.getFormattedString("Threads_sur", javaInformations.getHost()));
            this.write(": </b>");
            this.writeln(HtmlCoreReport.getFormattedString("thread_count", javaInformations.getThreadCount(), javaInformations.getPeakThreadCount(), javaInformations.getTotalStartedThreadCount()));
            HtmlThreadInformationsReport htmlThreadInformationsReport = new HtmlThreadInformationsReport(javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.getWriter());
            htmlThreadInformationsReport.writeDeadlocks();
            this.writeln("<br/><br/>");
            htmlThreadInformationsReport.toHtml();
        }
    }

    void writeThreadsDump() throws IOException {
        this.writeDirectly(I18N.getCurrentDateAndTime());
        this.writeDirectly("\n\n");
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.writeDirectly("===== " + HtmlCoreReport.getFormattedString("Threads_sur", javaInformations.getHost()) + " =====");
            this.writeDirectly("\n\n");
            HtmlThreadInformationsReport htmlThreadInformationsReport = new HtmlThreadInformationsReport(javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.getWriter());
            htmlThreadInformationsReport.writeThreadsDump();
        }
    }

    private void writeThreads() throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.write("<b>");
            this.writeDirectly(HtmlCoreReport.getFormattedString("Threads_sur", javaInformations.getHost()));
            this.write(": </b>");
            this.writeln(HtmlCoreReport.getFormattedString("thread_count", javaInformations.getThreadCount(), javaInformations.getPeakThreadCount(), javaInformations.getTotalStartedThreadCount()));
            this.writeln(SEPARATOR);
            List<ThreadInformations> threadInformationsList = javaInformations.getThreadInformationsList();
            HtmlThreadInformationsReport htmlThreadInformationsReport = new HtmlThreadInformationsReport(threadInformationsList, javaInformations.isStackTraceEnabled(), this.getWriter());
            if (threadInformationsList.size() <= 500) {
                String id = "threads_" + i;
                this.writeShowHideLink(id, "#Details#");
                htmlThreadInformationsReport.writeDeadlocks();
                this.writeln("<br/><br/><div id='" + id + "' class='displayNone'>");
                htmlThreadInformationsReport.toHtml();
                this.writeln("<div align='right' class='noPrint'><br/>");
                if (javaInformations.isStackTraceEnabled()) {
                    this.writeln("<a href='?part=threadsDump'><img src='?resource=text.png' alt='#Dump_threads_en_texte#'/>&nbsp;#Dump_threads_en_texte#</a>");
                }
                this.writeln(SEPARATOR);
                this.writeln("<a href='?part=threads'><img src='?resource=threads.png' alt='#Threads#' width='16' height='16'/>&nbsp;#Voir_dans_une_nouvelle_page#</a>");
                this.writeln(END_DIV);
                this.writeln("</div><br/>");
            } else {
                this.writeln("<a href='?part=threads' class='noPrint'>#Details#</a><br/>");
            }
            ++i;
        }
    }

    void writeCounterSummaryPerClass(String counterName, String requestId) throws IOException {
        Counter counter = this.collector.getRangeCounter(this.range, counterName);
        this.writeln("<div class='noPrint'>");
        this.writeln("<a class='back' href=''><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln(SEPARATOR);
        String hrefStart = "<a href='?part=counterSummaryPerClass&amp;counter=" + counter.getName() + (String)(requestId == null ? "" : "&amp;graph=" + HtmlCoreReport.urlEncode(requestId));
        this.writeln(hrefStart + "'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlCoreReport.isPdfEnabled()) {
            this.writeln(SEPARATOR);
            this.write(hrefStart);
            this.writeln("&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln(END_DIV);
        this.writeCounterTitle(counter);
        HtmlCounterReport htmlCounterReport = new HtmlCounterReport(counter, this.range, this.getWriter());
        htmlCounterReport.writeRequestsAggregatedOrFilteredByClassName(requestId);
    }

    private boolean isGcEnabled() {
        return Action.GC_ENABLED || this.collectorServer != null;
    }

    private boolean isHeapHistoEnabled() {
        return this.collectorServer != null || VirtualMachine.isEnabled();
    }

    private boolean isSamplingEnabled() {
        return this.collectorServer != null || this.collector.getSamplingProfiler() != null;
    }

    private boolean isDatabaseEnabled() {
        return !Parameters.isNoDatabase() && this.javaInformationsList.get(0).getDataBaseVersion() != null && !this.javaInformationsList.get(0).getDataBaseVersion().contains("Exception");
    }

    private boolean doesWebXmlExists() {
        return this.javaInformationsList.get(0).doesWebXmlExists();
    }

    private boolean isSessionsEnabled() {
        return this.javaInformationsList.get(0).getSessionCount() >= 0;
    }

    private boolean isSpringBeansEnabled() {
        return this.javaInformationsList.get(0).isSpringBeansEnabled();
    }

    private boolean isCacheEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            return true;
        }
        return false;
    }

    private boolean isJCacheEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJCacheEnabled()) continue;
            return true;
        }
        return false;
    }

    private boolean isJobEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJobEnabled()) continue;
            return true;
        }
        return false;
    }

    List<HsErrPid> getHsErrPidList() {
        return HsErrPid.getHsErrPidList(this.javaInformationsList);
    }

    private void writeCaches() throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            List<CacheInformations> cacheInformationsList = javaInformations.getCacheInformationsList();
            this.writeln("<b>");
            this.writeln(HtmlCoreReport.getFormattedString("caches_sur", cacheInformationsList.size(), javaInformations.getHost()));
            this.writeln("</b>");
            this.writeln(SEPARATOR);
            String id = "caches_" + i;
            this.writeShowHideLink(id, "#Details#");
            this.writeln("<br/><br/><div id='" + id + "' class='displayNone'><div>");
            new HtmlCacheInformationsReport(cacheInformationsList, this.getWriter()).toHtml();
            this.writeln("</div></div><br/>");
            ++i;
        }
    }

    private void writeJCaches() throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJCacheEnabled()) continue;
            List<JCacheInformations> jcacheInformationsList = javaInformations.getJCacheInformationsList();
            this.writeln("<b>");
            this.writeln(HtmlCoreReport.getFormattedString("caches_sur", jcacheInformationsList.size(), javaInformations.getHost()));
            this.writeln("</b>");
            this.writeln(SEPARATOR);
            String id = "jcaches_" + i;
            this.writeShowHideLink(id, "#Details#");
            this.writeln("<br/><br/><div id='" + id + "' class='displayNone'><div>");
            new HtmlJCacheInformationsReport(jcacheInformationsList, this.getWriter()).toHtml();
            this.writeln("</div></div><br/>");
            ++i;
        }
    }

    private void writeJobs(Counter rangeJobCounter) throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJobEnabled()) continue;
            List<JobInformations> jobInformationsList = javaInformations.getJobInformationsList();
            this.writeln("<b>");
            this.writeln(HtmlCoreReport.getFormattedString("jobs_sur", jobInformationsList.size(), javaInformations.getHost(), javaInformations.getCurrentlyExecutingJobCount()));
            this.writeln("</b>");
            this.writeln(SEPARATOR);
            String id = "job_" + i;
            this.writeShowHideLink(id, "#Details#");
            this.writeln("<br/><br/><div id='" + id + "' class='displayNone'><div>");
            new HtmlJobInformationsReport(jobInformationsList, rangeJobCounter, this.getWriter()).toHtml();
            this.writeln("</div></div><br/>");
            ++i;
        }
        this.writeCounter(rangeJobCounter);
    }

    private void writeSystemActionsLinks() throws IOException {
        int hsErrPidCount;
        this.writeln("<div align='center' class='noPrint'>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;";
        if (this.isGcEnabled()) {
            this.write("<a href='?action=gc" + HtmlCoreReport.getCsrfTokenUrlPart() + "' class='confirm' data-confirm='" + HtmlCoreReport.htmlEncodeButNotSpaceAndNewLine(HtmlCoreReport.getString("confirm_ramasse_miette")) + "'>");
        } else {
            this.write("<a href='?action=gc" + HtmlCoreReport.getCsrfTokenUrlPart() + "' class='alertAndStop' data-alert='" + HtmlCoreReport.htmlEncodeButNotSpaceAndNewLine(HtmlCoreReport.getString("ramasse_miette_desactive")) + "'>");
        }
        this.write("<img src='?resource=broom.png' width='20' height='20' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.write("<a href='?action=heap_dump" + HtmlCoreReport.getCsrfTokenUrlPart() + "' class='confirm' data-confirm='" + HtmlCoreReport.htmlEncodeButNotSpaceAndNewLine(HtmlCoreReport.getString("confirm_heap_dump")) + "'>");
        this.write("<img src='?resource=heapdump.png' width='20' height='20' alt=\"#heap_dump#\" /> #heap_dump#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        if (this.isHeapHistoEnabled()) {
            this.write("<a href='?part=heaphisto'>");
            this.write("<img src='?resource=memory.png' width='20' height='20' alt=\"#heaphisto#\" /> #heaphisto#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        if (this.isSessionsEnabled()) {
            this.write("<a href='?action=invalidate_sessions" + HtmlCoreReport.getCsrfTokenUrlPart() + "' class='confirm' data-confirm='" + HtmlCoreReport.htmlEncodeButNotSpaceAndNewLine(HtmlCoreReport.getString("confirm_invalidate_sessions")) + "'>");
            this.write("<img src='?resource=user-trash.png' width='18' height='18' alt=\"#invalidate_sessions#\" /> #invalidate_sessions#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=sessions'>");
            this.writeln("<img src='?resource=system-users.png' width='20' height='20' alt=\"#sessions#\" /> #sessions#</a>");
        }
        if (this.isSamplingEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=hotspots'>");
            this.writeln("<img src='?resource=clock.png' width='20' height='20' alt=\"#hotspots#\" /> #hotspots#</a>");
        }
        this.writeln("<br />");
        if (this.doesWebXmlExists()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=web.xml'>");
            this.write("<img src='?resource=xml.png' width='20' height='20' alt=\"#web.xml#\" /> #web.xml#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.write("<a href='?part=mbeans'>");
        this.write("<img src='?resource=mbeans.png' width='20' height='20' alt=\"#MBeans#\" /> #MBeans#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.write("<a href='?part=processes'>");
        this.write("<img src='?resource=processes.png' width='20' height='20' alt=\"#processes#\" /> #processes#</a>");
        String serverInfo = this.javaInformationsList.get(0).getServerInfo();
        if (serverInfo != null && !serverInfo.contains("Winstone")) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=jndi'>");
            this.write("<img src='?resource=jndi.png' width='20' height='20' alt=\"#Arbre_JNDI#\" /> #Arbre_JNDI#</a>");
        }
        if (this.isSpringBeansEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=springBeans'>");
            this.write("<img src='?resource=beans.png' width='20' height='20' alt=\"#Spring_beans#\" /> #Spring_beans#</a>");
        }
        if (this.isDatabaseEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=connections'>");
            this.write("<img src='?resource=db.png' width='20' height='20' alt=\"#Connexions_jdbc_ouvertes#\" /> #Connexions_jdbc_ouvertes#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=database'>");
            this.writeln("<img src='?resource=db.png' width='20' height='20' alt=\"#database#\" /> #database#</a>");
        }
        if ((hsErrPidCount = this.getHsErrPidList().size()) > 0) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=crashes'>");
            this.write("<img src='?resource=alert.png' width='20' height='20' alt=\"#Crashes# (" + hsErrPidCount + ")\" /> #Crashes# (" + hsErrPidCount + ")</a>");
        }
        this.writeln("<br/></div>");
    }

    private void writeApplicationsLinks() throws IOException {
        assert (this.collectorServer != null);
        this.writeln("<div align='center'>");
        ArrayList<String> applications = new ArrayList<String>(Parameters.getCollectorUrlsByApplications().keySet());
        applications.addAll(Parameters.getApplicationsByAggregationApplication().keySet());
        if (applications.size() > 1 || !this.collectorServer.getLastCollectExceptionsByApplication().isEmpty()) {
            boolean tabularList;
            boolean bl = tabularList = applications.size() > 10;
            if (tabularList) {
                this.writeln("<table summary='applications'><tr><td>");
                this.writeShowHideLink("chooseApplication", "#Choix_application#");
                if (Parameters.getCollectorApplicationsFile().canWrite()) {
                    HtmlCoreReport.writeAddAndRemoveApplicationLinks(this.collector.getApplication(), applications, this.getWriter());
                }
                this.writeln("<div id='chooseApplication' class='displayNone'><div>&nbsp;&nbsp;&nbsp;");
                this.writeApplicationsLinks(applications, tabularList);
                this.writeln("</div></div></td></tr></table>");
            } else {
                this.writeln("&nbsp;&nbsp;&nbsp;#Choix_application# :&nbsp;&nbsp;&nbsp;");
                this.writeApplicationsLinks(applications, tabularList);
                if (Parameters.getCollectorApplicationsFile().canWrite()) {
                    HtmlCoreReport.writeAddAndRemoveApplicationLinks(this.collector.getApplication(), applications, this.getWriter());
                }
            }
        } else if (Parameters.getCollectorApplicationsFile().canWrite()) {
            HtmlCoreReport.writeAddAndRemoveApplicationLinks(this.collector.getApplication(), applications, this.getWriter());
        }
        this.writeln(END_DIV);
    }

    private void writeApplicationsLinks(Collection<String> applications, boolean tabularList) throws IOException {
        Map<String, Throwable> lastCollectExceptionsByApplication = this.collectorServer.getLastCollectExceptionsByApplication();
        if (tabularList) {
            this.writeln("<table><tr><td>");
        }
        int nbColumns = 5;
        int i = 0;
        for (String application : applications) {
            Throwable lastCollectException = lastCollectExceptionsByApplication.get(application);
            this.writeln("<a href='?application=" + application + "' class='tooltip'>");
            if (lastCollectException == null) {
                this.writeln("<img src='?resource=bullets/green.png' alt='#Application_disponible#'/>");
                this.writeln("<em class='applicationStatus'>");
                this.writeln("#Application_disponible#");
            } else {
                this.writeln("<img src='?resource=bullets/red.png' alt='#Application_indisponible#'/>");
                this.writeln("<em class='applicationStatus'>");
                this.writeln("#Application_indisponible#:<br/>");
                this.writeDirectly(HtmlCoreReport.htmlEncode(lastCollectException.toString()));
                this.writeDirectly("<br/>");
                for (StackTraceElement stackTraceElement : lastCollectException.getStackTrace()) {
                    this.writeDirectly(HtmlCoreReport.htmlEncode(stackTraceElement.toString()));
                    this.writeDirectly("<br/>");
                }
            }
            this.writeln("</em>");
            this.writeln(application + "</a>");
            ++i;
            if (tabularList) {
                if (i % 5 == 0) {
                    this.writeln("</td></tr><tr><td>");
                    continue;
                }
                this.writeln("</td><td>");
                continue;
            }
            this.writeln("&nbsp;&nbsp;&nbsp;");
        }
        if (tabularList) {
            this.writeln("</td></tr></table>");
        }
    }

    void writeRefreshAndPeriodLinks(String graphName, String part) throws IOException {
        this.writeln("<div class='noPrint'>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String graphParameter = "&amp;graph=";
        if (graphName == null) {
            this.write("<a href='?' title='#Rafraichir#'>");
        } else {
            this.write("<a class='back' href=''><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?'><img src='?resource=action_home.png' alt='#Page_principale#'/> #Page_principale#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=" + part + "&amp;graph=" + HtmlCoreReport.urlEncode(graphName) + "' title='#Rafraichir#'>");
        }
        this.write("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlCoreReport.isPdfEnabled() && !"usages".equals(part)) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            if (graphName == null) {
                this.write("<a href='?format=pdf' title='#afficher_PDF#'>");
            } else {
                this.write("<a href='?part=" + part + "&amp;graph=" + HtmlCoreReport.urlEncode(graphName) + "&amp;format=pdf' title='#afficher_PDF#'>");
            }
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.write("<a href='?resource=#help_url#' target='_blank'");
        this.write(" title=\"#Afficher_aide_en_ligne#\"><img src='?resource=action_help.png' alt='#Aide_en_ligne#'/> #Aide_en_ligne#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.write("<a href='?part=jnlp'");
        this.write(" title=\"#RDA#\"><img src='?resource=systemmonitor.png' width='16' height='16' alt='#RDA#'/> #Desktop#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("#Choix_periode# :&nbsp;");
        for (Period myPeriod : Period.values()) {
            if (graphName == null) {
                this.write("<a href='?period=" + myPeriod.getCode() + "' ");
            } else {
                this.write("<a href='?part=" + part + "&amp;graph=" + HtmlCoreReport.urlEncode(graphName) + "&amp;period=" + myPeriod.getCode() + "' ");
            }
            this.write("title='" + HtmlCoreReport.getFormattedString("Choisir_periode", myPeriod.getLinkLabel()) + "'>");
            this.write("<img src='?resource=" + myPeriod.getIconName() + "' alt='" + myPeriod.getLinkLabel() + "' /> ");
            this.writeln(myPeriod.getLinkLabel() + "</a>&nbsp;");
        }
        HtmlForms htmlForms = new HtmlForms(this.getWriter());
        Map<String, Date> datesByWebappVersions = this.collector.getDatesByWebappVersions();
        htmlForms.writeCustomPeriodLinks(datesByWebappVersions, this.range, graphName, part);
        this.writeln(END_DIV);
    }

    private void writeDurationAndOverhead() throws IOException {
        long displayDuration = System.currentTimeMillis() - this.start;
        this.writeln("<a name='bottom'></a>");
        this.writeln("<br/><div class='durationAndOverHead'>");
        this.writeln("#temps_derniere_collecte#: " + this.collector.getLastCollectDuration() + " #ms#<br/>");
        this.writeln("#temps_affichage#: " + displayDuration + " #ms#<br/>");
        this.writeln("#Estimation_overhead_memoire#: < " + (this.collector.getEstimatedMemorySize() / 1024L / 1024L + 1L) + " #Mo#");
        this.writeln("<br/>#Usage_disque#: " + (this.collector.getDiskUsage() / 1024L / 1024L + 1L) + " #Mo#");
        if (Parameters.isSystemActionsEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;<a href='?action=purge_obsolete_files" + HtmlCoreReport.getCsrfTokenUrlPart() + "' class='noPrint'>");
            this.writeln("<img width='14' height='14' src='?resource=user-trash.png' alt='#Purger_les_fichiers_obsoletes#' title='#Purger_les_fichiers_obsoletes#'/></a>");
        }
        if (Parameters.JAVAMELODY_VERSION != null) {
            this.writeln("<br/><br/>JavaMelody " + Parameters.JAVAMELODY_VERSION);
        }
        if (this.collectorServer == null) {
            this.writeln("<br/>");
            this.writeShowHideLink("debuggingLogs", "Debugging logs");
            this.writeln("<br/><br/>");
            this.writeln("<div id='debuggingLogs' class='displayNone'>");
            List<String> debuggingLogs = LOG.getDebuggingLogs();
            if (debuggingLogs.size() >= 50) {
                this.writeln("<div class='severe'>Only the last 50 messages are displayed</div>");
            }
            for (String msg : debuggingLogs) {
                this.writeDirectly(HtmlCoreReport.htmlEncodeButNotSpace(msg).replace("\t", SEPARATOR));
                this.writeln("<br/>");
            }
            this.writeln(END_DIV);
        }
        this.writeln(END_DIV);
    }
}

