/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class MappingNamespaceContext
implements NamespaceContext {
    private final Map<String, List<String>> namespacesByUri = new HashMap<String, List<String>>();
    private final HashMap<String, String> namespacesByPrefix = new HashMap();

    public MappingNamespaceContext add(String prefix, String namespaceUri) {
        MappingNamespaceContext.putMapValue(this.namespacesByUri, namespaceUri, prefix);
        this.namespacesByPrefix.put(prefix, namespaceUri);
        return this;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespacesByPrefix.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.getPrefixes(namespaceURI).hasNext() ? (String)this.getPrefixes(namespaceURI).next() : null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        return MappingNamespaceContext.getMapValues(this.namespacesByUri, namespaceURI).iterator();
    }

    private static List<String> getMapValues(Map<String, List<String>> map, String key) {
        List<String> val = map.get(key);
        return val == null ? Collections.emptyList() : val;
    }

    private static void putMapValue(Map<String, List<String>> map, String key, String value) {
        List<String> values = map.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            map.put(key, values);
        }
        values.add(value);
    }
}

