/*
 * Decompiled with CFR 0.152.
 */
package net.corda.common.validation.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.common.validation.internal.Validated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000  *\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0002 !J(\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J.\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0018\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J.\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00150\u0011H&J.\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00180\u0000\"\u0004\b\u0002\u0010\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00180\u0011H&J:\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u00152\u001e\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00028\u00010\u00000\u0011H&J-\u0010\u001b\u001a\u00028\u00002\u001e\b\u0002\u0010\u001c\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\b\u0012\u00060\u001dj\u0002`\u001e0\u0011H&\u00a2\u0006\u0002\u0010\u001fR\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\f\u001a\u0004\u0018\u00018\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lnet/corda/common/validation/internal/Validated;", "TARGET", "ERROR", "", "errors", "", "getErrors", "()Ljava/util/Set;", "isInvalid", "", "()Z", "isValid", "optional", "getOptional", "()Ljava/lang/Object;", "doIfValid", "action", "Lkotlin/Function1;", "", "doOnErrors", "map", "MAPPED", "convert", "mapErrors", "MAPPED_ERROR", "convertError", "mapValid", "value", "exceptionOnErrors", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "Result", "common-validation"})
public interface Validated<TARGET, ERROR> {
    public static final Companion Companion = net.corda.common.validation.internal.Validated$Companion.$$INSTANCE;

    public TARGET value(@NotNull Function1<? super Set<? extends ERROR>, ? extends Exception> var1);

    @NotNull
    public Set<ERROR> getErrors();

    public boolean isValid();

    public boolean isInvalid();

    @Nullable
    public TARGET getOptional();

    @NotNull
    public <MAPPED> Validated<MAPPED, ERROR> map(@NotNull Function1<? super TARGET, ? extends MAPPED> var1);

    @NotNull
    public <MAPPED> Validated<MAPPED, ERROR> mapValid(@NotNull Function1<? super TARGET, ? extends Validated<MAPPED, ERROR>> var1);

    @NotNull
    public <MAPPED_ERROR> Validated<TARGET, MAPPED_ERROR> mapErrors(@NotNull Function1<? super ERROR, ? extends MAPPED_ERROR> var1);

    @NotNull
    public Validated<TARGET, ERROR> doIfValid(@NotNull Function1<? super TARGET, Unit> var1);

    @NotNull
    public Validated<TARGET, ERROR> doOnErrors(@NotNull Function1<? super Set<? extends ERROR>, Unit> var1);

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0002\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lnet/corda/common/validation/internal/Validated$Result;", "TARGET", "ERROR", "Lnet/corda/common/validation/internal/Validated;", "()V", "Successful", "Unsuccessful", "Lnet/corda/common/validation/internal/Validated$Result$Successful;", "Lnet/corda/common/validation/internal/Validated$Result$Unsuccessful;", "common-validation"})
    public static abstract class Result<TARGET, ERROR>
    implements Validated<TARGET, ERROR> {
        private Result() {
        }

        @Override
        public boolean isValid() {
            return DefaultImpls.isValid(this);
        }

        @Override
        public boolean isInvalid() {
            return DefaultImpls.isInvalid(this);
        }

        @Override
        @Nullable
        public TARGET getOptional() {
            return DefaultImpls.getOptional(this);
        }

        @Override
        @NotNull
        public Validated<TARGET, ERROR> doIfValid(@NotNull Function1<? super TARGET, Unit> action) {
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            return DefaultImpls.doIfValid(this, action);
        }

        @Override
        @NotNull
        public Validated<TARGET, ERROR> doOnErrors(@NotNull Function1<? super Set<? extends ERROR>, Unit> action) {
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            return DefaultImpls.doOnErrors(this, action);
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0004\u0010\u0001*\u0004\b\u0005\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\u0006J.\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00028\u00050\u0004\"\u0004\b\u0006\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u0002H\r0\u000fH\u0016J.\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u0002H\u00110\u0004\"\u0004\b\u0006\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u00110\u000fH\u0016J:\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00028\u00050\u0004\"\u0004\b\u0006\u0010\r2\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00028\u00050\u00040\u000fH\u0016J+\u0010\u0005\u001a\u00028\u00042\u001c\u0010\u0014\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00050\b\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00050\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u00028\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lnet/corda/common/validation/internal/Validated$Result$Successful;", "TARGET", "ERROR", "Lnet/corda/common/validation/internal/Validated$Result;", "Lnet/corda/common/validation/internal/Validated;", "value", "(Ljava/lang/Object;)V", "errors", "", "getErrors", "()Ljava/util/Set;", "Ljava/lang/Object;", "map", "MAPPED", "convert", "Lkotlin/Function1;", "mapErrors", "MAPPED_ERROR", "convertError", "mapValid", "exceptionOnErrors", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "common-validation"})
        public static final class Successful<TARGET, ERROR>
        extends Result<TARGET, ERROR>
        implements Validated<TARGET, ERROR> {
            @NotNull
            private final Set<ERROR> errors;
            private final TARGET value;

            @Override
            @NotNull
            public Set<ERROR> getErrors() {
                return this.errors;
            }

            @Override
            public TARGET value(@NotNull Function1<? super Set<? extends ERROR>, ? extends Exception> exceptionOnErrors) {
                Intrinsics.checkParameterIsNotNull(exceptionOnErrors, (String)"exceptionOnErrors");
                return this.value;
            }

            @Override
            @NotNull
            public <MAPPED> Validated<MAPPED, ERROR> map(@NotNull Function1<? super TARGET, ? extends MAPPED> convert) {
                Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
                return Companion.valid(convert.invoke(this.value));
            }

            @Override
            @NotNull
            public <MAPPED> Validated<MAPPED, ERROR> mapValid(@NotNull Function1<? super TARGET, ? extends Validated<MAPPED, ERROR>> convert) {
                Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
                return (Validated)convert.invoke(this.value);
            }

            @Override
            @NotNull
            public <MAPPED_ERROR> Validated<TARGET, MAPPED_ERROR> mapErrors(@NotNull Function1<? super ERROR, ? extends MAPPED_ERROR> convertError) {
                Intrinsics.checkParameterIsNotNull(convertError, (String)"convertError");
                return Companion.valid(this.value);
            }

            public Successful(TARGET value2) {
                super(null);
                this.value = value2;
                Set set = Collections.emptySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"emptySet<ERROR>()");
                this.errors = set;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0004\u0010\u0001*\u0004\b\u0005\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00050\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00028\u00050\u0004\"\u0004\b\u0006\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u0002H\u000b0\rH\u0016J.\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u0002H\u000f0\u0004\"\u0004\b\u0006\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u000f0\rH\u0016J:\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00028\u00050\u0004\"\u0004\b\u0006\u0010\u000b2\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00028\u00050\u00040\rH\u0016J&\u0010\u0012\u001a\u00020\u00132\u001c\u0010\u0014\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00050\u0006\u0012\b\u0012\u00060\u0015j\u0002`\u00160\rH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00050\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lnet/corda/common/validation/internal/Validated$Result$Unsuccessful;", "TARGET", "ERROR", "Lnet/corda/common/validation/internal/Validated$Result;", "Lnet/corda/common/validation/internal/Validated;", "errors", "", "(Ljava/util/Set;)V", "getErrors", "()Ljava/util/Set;", "map", "MAPPED", "convert", "Lkotlin/Function1;", "mapErrors", "MAPPED_ERROR", "convertError", "mapValid", "value", "", "exceptionOnErrors", "Ljava/lang/Exception;", "Lkotlin/Exception;", "common-validation"})
        public static final class Unsuccessful<TARGET, ERROR>
        extends Result<TARGET, ERROR>
        implements Validated<TARGET, ERROR> {
            @NotNull
            private final Set<ERROR> errors;

            @Override
            @NotNull
            public Void value(@NotNull Function1<? super Set<? extends ERROR>, ? extends Exception> exceptionOnErrors) {
                Intrinsics.checkParameterIsNotNull(exceptionOnErrors, (String)"exceptionOnErrors");
                throw (Throwable)exceptionOnErrors.invoke(this.getErrors());
            }

            @Override
            @NotNull
            public <MAPPED> Validated<MAPPED, ERROR> map(@NotNull Function1<? super TARGET, ? extends MAPPED> convert) {
                Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
                return Companion.invalid(this.getErrors());
            }

            @Override
            @NotNull
            public <MAPPED> Validated<MAPPED, ERROR> mapValid(@NotNull Function1<? super TARGET, ? extends Validated<MAPPED, ERROR>> convert) {
                Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
                return Companion.invalid(this.getErrors());
            }

            @Override
            @NotNull
            public <MAPPED_ERROR> Validated<TARGET, MAPPED_ERROR> mapErrors(@NotNull Function1<? super ERROR, ? extends MAPPED_ERROR> convertError) {
                Intrinsics.checkParameterIsNotNull(convertError, (String)"convertError");
                return Companion.invalid(SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getErrors()), convertError)));
            }

            @Override
            @NotNull
            public Set<ERROR> getErrors() {
                return this.errors;
            }

            public Unsuccessful(@NotNull Set<? extends ERROR> errors) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
                super(null);
                this.errors = errors;
                Collection collection = this.getErrors();
                boolean bl2 = bl = !collection.isEmpty();
                if (!bl) {
                    String string = "No errors encountered during validation";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        public static /* bridge */ /* synthetic */ Object value$default(Validated validated, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: value");
            }
            if ((n & 1) != 0) {
                function1 = value.1.INSTANCE;
            }
            return validated.value(function1);
        }

        public static <TARGET, ERROR> boolean isValid(Validated<TARGET, ERROR> $this) {
            return $this.getErrors().isEmpty();
        }

        public static <TARGET, ERROR> boolean isInvalid(Validated<TARGET, ERROR> $this) {
            return !$this.isValid();
        }

        @Nullable
        public static <TARGET, ERROR> TARGET getOptional(Validated<TARGET, ERROR> $this) {
            return (TARGET)($this.isValid() ? DefaultImpls.value$default($this, null, 1, null) : null);
        }

        @NotNull
        public static <TARGET, ERROR> Validated<TARGET, ERROR> doIfValid(Validated<TARGET, ERROR> $this, @NotNull Function1<? super TARGET, Unit> action) {
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            if ($this.isValid()) {
                action.invoke(DefaultImpls.value$default($this, null, 1, null));
            }
            return $this;
        }

        @NotNull
        public static <TARGET, ERROR> Validated<TARGET, ERROR> doOnErrors(Validated<TARGET, ERROR> $this, @NotNull Function1<? super Set<? extends ERROR>, Unit> action) {
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            if ($this.isInvalid()) {
                action.invoke($this.getErrors());
            }
            return $this;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006\u00a2\u0006\u0002\u0010\tJ,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\nJ+\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\f\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\rJ9\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u000f\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\f\u001a\u0002H\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\n\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lnet/corda/common/validation/internal/Validated$Companion;", "", "()V", "invalid", "Lnet/corda/common/validation/internal/Validated$Result;", "T", "E", "errors", "", "([Ljava/lang/Object;)Lnet/corda/common/validation/internal/Validated$Result;", "", "valid", "target", "(Ljava/lang/Object;)Lnet/corda/common/validation/internal/Validated$Result;", "withResult", "Lnet/corda/common/validation/internal/Validated;", "(Ljava/lang/Object;Ljava/util/Set;)Lnet/corda/common/validation/internal/Validated;", "common-validation"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final <T, E> Result<T, E> valid(T target) {
            return new Result.Successful(target);
        }

        @NotNull
        public final <T, E> Result<T, E> invalid(@NotNull Set<? extends E> errors) {
            Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
            return new Result.Unsuccessful(errors);
        }

        @NotNull
        public final <T, E> Result<T, E> invalid(E ... errors) {
            Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
            return this.invalid(ArraysKt.toSet((Object[])errors));
        }

        @NotNull
        public final <T, E> Validated<T, E> withResult(T target, @NotNull Set<? extends E> errors) {
            Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
            return errors.isEmpty() ? (Validated)this.valid(target) : (Validated)this.invalid(errors);
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

