/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.greghaines.jesque.utils.JesqueUtils;

public class Job
implements Serializable {
    private static final long serialVersionUID = -1523425239512691383L;
    private String className;
    private Object[] args;
    private Map<String, Object> vars;
    private Map<String, Object> unknownFields = new HashMap<String, Object>();
    private Double runAt;

    public Job() {
    }

    public Job(Job origJob) {
        if (origJob == null) {
            throw new IllegalArgumentException("origJob must not be null");
        }
        this.className = origJob.className;
        this.args = origJob.args == null ? null : (Object[])origJob.args.clone();
        this.vars = origJob.vars == null ? null : new LinkedHashMap<String, Object>(origJob.vars);
    }

    public Job(String className, List<?> args) {
        this(className, args.toArray());
    }

    public Job(String className, Object ... args) {
        if (className == null || "".equals(className)) {
            throw new IllegalArgumentException("className must not be null or empty: " + className);
        }
        this.className = className;
        this.args = args;
    }

    public Job(String className, Map<String, ? extends Object> vars) {
        if (className == null || "".equals(className)) {
            throw new IllegalArgumentException("className must not be null or empty: " + className);
        }
        this.className = className;
        this.vars = vars;
    }

    @JsonCreator
    public Job(@JsonProperty(value="class") String className, @JsonProperty(value="args") Object[] args, @JsonProperty(value="vars") Map<String, ? extends Object> vars) {
        if (className == null || "".equals(className)) {
            throw new IllegalArgumentException("className must not be null or empty: " + className);
        }
        this.className = className;
        this.args = args;
        this.vars = vars;
    }

    @JsonProperty(value="class", required=true)
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @JsonProperty
    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object ... args) {
        this.args = args;
    }

    @JsonProperty
    public Map<String, Object> getVars() {
        return this.vars;
    }

    public void setVars(Map<String, ? extends Object> vars) {
        this.vars = vars;
    }

    @JsonIgnore
    public Double getRunAt() {
        return this.runAt;
    }

    @JsonIgnore
    public void setRunAt(Double runAt) {
        this.runAt = runAt;
    }

    @JsonIgnore
    public boolean isValid() {
        return (this.args != null || this.vars != null) && this.className != null && !"".equals(this.className);
    }

    @JsonIgnore
    public Object getUnknownField(String fieldName) {
        return this.unknownFields.get(fieldName);
    }

    @JsonAnyGetter
    public Map<String, Object> getUnknownFields() {
        return this.unknownFields;
    }

    @JsonAnySetter
    public void setUnknownField(String name, Object value) {
        this.unknownFields.put(name, value);
    }

    @JsonIgnore
    public void setUnknownFields(Map<String, Object> unknownFields) {
        this.unknownFields.clear();
        this.unknownFields.putAll(unknownFields);
    }

    public String toString() {
        return "Job [class=" + this.className + ", args=" + Arrays.toString(this.args) + ", vars=" + this.vars + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.vars == null ? 0 : this.vars.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj instanceof Job) {
            Job other = (Job)obj;
            equal = JesqueUtils.nullSafeEquals(this.className, other.className) && Arrays.equals(this.args, other.args) && JesqueUtils.nullSafeEquals(this.vars, other.vars);
        }
        return equal;
    }
}

