/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.utils.JesqueUtils;

public class WorkerStatus
implements Serializable {
    private static final long serialVersionUID = 1852915628988733048L;
    @JsonProperty(value="run_at")
    private Date runAt;
    @JsonProperty
    private String queue;
    @JsonProperty
    private Job payload;
    @JsonProperty
    private boolean paused = false;

    public WorkerStatus() {
    }

    public WorkerStatus(WorkerStatus origStatus) {
        if (origStatus == null) {
            throw new IllegalArgumentException("origStatus must not be null");
        }
        this.runAt = origStatus.runAt;
        this.queue = origStatus.queue;
        this.payload = origStatus.payload;
        this.paused = origStatus.paused;
    }

    public Date getRunAt() {
        return this.runAt;
    }

    public void setRunAt(Date runAt) {
        this.runAt = runAt;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public Job getPayload() {
        return this.payload;
    }

    public void setPayload(Job payload) {
        this.payload = payload;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public String toString() {
        return "WorkerStatus [queue=" + this.queue + ", runAt=" + this.runAt + ", paused=" + Boolean.toString(this.paused) + ", payload=" + this.payload + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.paused ? 1231 : 1237);
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.queue == null ? 0 : this.queue.hashCode());
        result = 31 * result + (this.runAt == null ? 0 : this.runAt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj instanceof WorkerStatus) {
            WorkerStatus other = (WorkerStatus)obj;
            equal = this.paused == other.paused && JesqueUtils.nullSafeEquals(this.queue, other.queue) && JesqueUtils.nullSafeEquals(this.runAt, other.runAt) && JesqueUtils.nullSafeEquals(this.payload, other.payload);
        }
        return equal;
    }
}

