/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.meta;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import net.greghaines.jesque.meta.KeyType;
import net.greghaines.jesque.utils.JesqueUtils;

public class KeyInfo
implements Comparable<KeyInfo>,
Serializable {
    private static final long serialVersionUID = 6243902746964006352L;
    private static final Pattern COLON_PATTERN = Pattern.compile(":");
    private String name;
    private String namespace;
    private KeyType type;
    private Long size;
    private List<String> arrayValue;

    public KeyInfo() {
    }

    public KeyInfo(String fullKey, KeyType type) {
        if (fullKey == null) {
            throw new IllegalArgumentException("fullKey must not be null");
        }
        String[] keyParts = COLON_PATTERN.split(fullKey, 2);
        if (keyParts.length != 2) {
            throw new IllegalArgumentException("Malformed fullKey: " + fullKey);
        }
        this.namespace = keyParts[0];
        this.name = keyParts[1];
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public KeyType getType() {
        return this.type;
    }

    public void setType(KeyType type) {
        this.type = type;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public List<String> getArrayValue() {
        return this.arrayValue;
    }

    public void setArrayValue(List<String> arrayValue) {
        this.arrayValue = arrayValue;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arrayValue == null ? 0 : this.arrayValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj instanceof KeyInfo) {
            KeyInfo other = (KeyInfo)obj;
            equal = JesqueUtils.nullSafeEquals(this.arrayValue, other.arrayValue) && JesqueUtils.nullSafeEquals(this.name, other.name) && JesqueUtils.nullSafeEquals(this.namespace, other.namespace) && JesqueUtils.nullSafeEquals(this.size, other.size) && JesqueUtils.nullSafeEquals((Object)this.type, (Object)other.type);
        }
        return equal;
    }

    @Override
    public int compareTo(KeyInfo other) {
        int retVal = 1;
        if (other != null) {
            if (this.name != null && other.name != null) {
                retVal = this.name.compareTo(other.name);
            } else if (this.name == null) {
                retVal = other.name == null ? 0 : -1;
            }
        }
        return retVal;
    }
}

