/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.worker;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.utils.ConcurrentHashSet;
import net.greghaines.jesque.utils.ConcurrentSet;
import net.greghaines.jesque.worker.Worker;
import net.greghaines.jesque.worker.WorkerEvent;
import net.greghaines.jesque.worker.WorkerEventEmitter;
import net.greghaines.jesque.worker.WorkerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerListenerDelegate
implements WorkerEventEmitter {
    private static final Logger log = LoggerFactory.getLogger(WorkerListenerDelegate.class);
    private final Map<WorkerEvent, ConcurrentSet<WorkerListener>> eventListenerMap;

    public WorkerListenerDelegate() {
        EnumMap elp = new EnumMap(WorkerEvent.class);
        for (WorkerEvent event : WorkerEvent.values()) {
            elp.put(event, new ConcurrentHashSet());
        }
        this.eventListenerMap = Collections.unmodifiableMap(elp);
    }

    @Override
    public void addListener(WorkerListener listener) {
        this.addListener(listener, WorkerEvent.values());
    }

    @Override
    public void addListener(WorkerListener listener, WorkerEvent ... events) {
        if (listener != null) {
            for (WorkerEvent event : events) {
                ConcurrentSet<WorkerListener> listeners = this.eventListenerMap.get((Object)event);
                if (listeners == null) continue;
                listeners.add(listener);
            }
        }
    }

    @Override
    public void removeListener(WorkerListener listener) {
        this.removeListener(listener, WorkerEvent.values());
    }

    @Override
    public void removeListener(WorkerListener listener, WorkerEvent ... events) {
        if (listener != null) {
            for (WorkerEvent event : events) {
                ConcurrentSet<WorkerListener> listeners = this.eventListenerMap.get((Object)event);
                if (listeners == null) continue;
                listeners.remove(listener);
            }
        }
    }

    @Override
    public void removeAllListeners() {
        this.removeAllListeners(WorkerEvent.values());
    }

    @Override
    public void removeAllListeners(WorkerEvent ... events) {
        for (WorkerEvent event : events) {
            ConcurrentSet<WorkerListener> listeners = this.eventListenerMap.get((Object)event);
            if (listeners == null) continue;
            listeners.clear();
        }
    }

    public void fireEvent(WorkerEvent event, Worker worker, String queue, Job job, Object runner, Object result, Throwable t) {
        ConcurrentSet<WorkerListener> listeners = this.eventListenerMap.get((Object)event);
        if (listeners != null) {
            for (WorkerListener listener : listeners) {
                if (listener == null) continue;
                try {
                    listener.onEvent(event, worker, queue, job, runner, result, t);
                }
                catch (Exception e) {
                    log.error("Failure executing listener " + listener + " for event " + (Object)((Object)event) + " from queue " + queue + " on worker " + worker, (Throwable)e);
                }
            }
        }
    }
}

