/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class MacClipboard
extends ImagePlus
implements PlugIn {
    static Clipboard clipboard;

    @Override
    public void run(String arg) {
        Image img = this.showSystemClipboard();
        if (img != null) {
            this.setImage(img);
        }
    }

    Image showSystemClipboard() {
        Image img = null;
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        try {
            Transferable transferable = clipboard.getContents(null);
            img = this.displayMacImage(transferable);
        }
        catch (Throwable e) {
            IJ.handleException(e);
        }
        return img;
    }

    Image displayMacImage(Transferable t) {
        Image img = this.getMacImage(t);
        if (img != null) {
            WindowManager.checkForDuplicateName = true;
            new ImagePlus("Clipboard", img).show();
        }
        return img;
    }

    Image getMacImage(Transferable t) {
        if (!this.isQTJavaInstalled()) {
            return null;
        }
        Image img = null;
        DataFlavor[] d = t.getTransferDataFlavors();
        if (d == null || d.length == 0) {
            return null;
        }
        try {
            Object is = t.getTransferData(d[0]);
            if (is == null || !(is instanceof InputStream)) {
                return null;
            }
            img = this.getImageFromPictStream((InputStream)is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    Image getImageFromPictStream(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] header = new byte[512];
            byte[] buf = new byte[4096];
            int retval = 0;
            int size = 0;
            baos.write(header, 0, 512);
            while ((retval = is.read(buf, 0, 4096)) > 0) {
                baos.write(buf, 0, retval);
            }
            baos.close();
            size = baos.size();
            if (size <= 0) {
                return null;
            }
            byte[] imgBytes = baos.toByteArray();
            Class<?> c = Class.forName("quicktime.QTSession");
            Method m = c.getMethod("isInitialized", null);
            Boolean b = (Boolean)m.invoke(null, null);
            if (!b.booleanValue()) {
                m = c.getMethod("open", null);
                m.invoke(null, null);
            }
            c = Class.forName("quicktime.util.QTHandle");
            Constructor<?> con = c.getConstructor(imgBytes.getClass());
            Object handle = con.newInstance(new Object[]{imgBytes});
            String s = new String("PICT");
            c = Class.forName("quicktime.util.QTUtils");
            m = c.getMethod("toOSType", s.getClass());
            Integer type = (Integer)m.invoke(null, s);
            c = Class.forName("quicktime.std.image.GraphicsImporter");
            Class[] classArray = new Class[1];
            classArray[0] = Integer.TYPE;
            con = c.getConstructor(classArray);
            Object importer = con.newInstance(type);
            m = c.getMethod("setDataHandle", Class.forName("quicktime.util.QTHandleRef"));
            m.invoke(importer, handle);
            m = c.getMethod("getNaturalBounds", null);
            Object rect = m.invoke(importer, null);
            c = Class.forName("quicktime.app.view.GraphicsImporterDrawer");
            con = c.getConstructor(importer.getClass());
            Object iDrawer = con.newInstance(importer);
            m = rect.getClass().getMethod("getWidth", null);
            Integer width = (Integer)m.invoke(rect, null);
            m = rect.getClass().getMethod("getHeight", null);
            Integer height = (Integer)m.invoke(rect, null);
            Dimension d = new Dimension(width, height);
            c = Class.forName("quicktime.app.view.QTImageProducer");
            con = c.getConstructor(iDrawer.getClass(), d.getClass());
            Object producer = con.newInstance(iDrawer, d);
            if (producer instanceof ImageProducer) {
                return Toolkit.getDefaultToolkit().createImage((ImageProducer)producer);
            }
        }
        catch (Exception e) {
            IJ.showStatus("" + e);
        }
        return null;
    }

    boolean isQTJavaInstalled() {
        boolean isInstalled = false;
        try {
            Class<?> c = Class.forName("quicktime.QTSession");
            isInstalled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isInstalled;
    }
}

