/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.util.FontUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;

class PlotObject
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int XY_DATA = 0;
    public static final int ARROWS = 1;
    public static final int LINE = 2;
    public static final int NORMALIZED_LINE = 3;
    public static final int DOTTED_LINE = 4;
    public static final int LABEL = 5;
    public static final int NORMALIZED_LABEL = 6;
    public static final int LEGEND = 7;
    public static final int AXIS_LABEL = 8;
    public static final int FRAME = 9;
    public static final int SHAPES = 10;
    static final int FONT_STYLE_MASK = 15;
    public static final int CONSTRUCTOR_DATA = 4096;
    public static final int HIDDEN = 8192;
    public int type = 0;
    public int flags;
    public float[] xValues;
    public float[] yValues;
    public float[] xEValues;
    public float[] yEValues;
    public ArrayList shapeData;
    public String shapeType;
    public int shape;
    public float lineWidth;
    public Color color;
    public Color color2;
    public double x;
    public double y;
    public double xEnd;
    public double yEnd;
    public int step;
    public String label;
    public int justification;
    public String macroCode;
    public int pointIndex;
    private transient Font font;
    private String fontFamily;
    private float fontSize;

    PlotObject(int type) {
        this.type = type;
    }

    PlotObject(float[] xValues, float[] yValues, float[] yErrorBars, int shape, float lineWidth, Color color, Color color2, String yLabel) {
        this.type = 0;
        this.xValues = xValues;
        this.yValues = yValues;
        this.yEValues = yErrorBars;
        this.shape = shape;
        this.lineWidth = lineWidth;
        this.color = color;
        this.color2 = color2;
        this.label = yLabel;
        if (shape == 9) {
            this.macroCode = yLabel;
        }
    }

    PlotObject(float[] x1, float[] y1, float[] x2, float[] y2, float lineWidth, Color color) {
        this.type = 1;
        this.xValues = x1;
        this.yValues = y1;
        this.xEValues = x2;
        this.yEValues = y2;
        this.lineWidth = lineWidth;
        this.color = color;
    }

    PlotObject(String shapeType, ArrayList shapeData, float lineWidth, Color color, Color color2) {
        this.type = 10;
        this.shapeData = shapeData;
        this.shapeType = shapeType;
        this.lineWidth = lineWidth;
        this.color = color;
        this.color2 = color2;
    }

    PlotObject(double x, double y, double xEnd, double yEnd, float lineWidth, int step, Color color, int type) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.xEnd = xEnd;
        this.yEnd = yEnd;
        this.lineWidth = lineWidth;
        this.step = step;
        this.color = color;
    }

    PlotObject(String label, double x, double y, int justification, Font font, Color color, int type) {
        this.type = type;
        this.label = label;
        this.x = x;
        this.y = y;
        this.justification = justification;
        this.setFont(font);
        this.color = color;
    }

    PlotObject(float lineWidth, Font font, Color color, int flags) {
        this.type = 7;
        this.lineWidth = lineWidth;
        this.setFont(font);
        this.color = color;
        this.flags = flags;
    }

    PlotObject(float lineWidth) {
        this.type = 9;
        this.color = Color.black;
        this.lineWidth = lineWidth;
    }

    boolean hasFlag(int what) {
        return (this.flags & what) != 0;
    }

    void setFlag(int what) {
        this.flags |= what;
    }

    void unsetFlag(int what) {
        this.flags &= ~what;
    }

    boolean hasCurve() {
        return this.type == 0 && (this.shape == 2 || this.shape == 7 || this.shape == 10);
    }

    boolean hasMarker() {
        return this.type == 0 && (this.shape == 0 || this.shape == 1 || this.shape == 3 || this.shape == 4 || this.shape == 5 || this.shape == 8 || this.shape == 6 || this.shape == 7 || this.shape == 9);
    }

    boolean hasFilledMarker() {
        return this.type == 0 && this.color2 != null && (this.shape == 0 || this.shape == 3 || this.shape == 4 || this.shape == 8);
    }

    int getMarkerSize() {
        return this.lineWidth <= 1.0f ? 5 : 7;
    }

    void setFont(Font font) {
        if (font == this.font) {
            return;
        }
        this.font = font;
        if (font == null) {
            this.fontFamily = null;
        } else {
            this.fontFamily = font.getFamily();
            this.flags = this.flags & 0xFFFFFFF0 | font.getStyle();
            this.fontSize = font.getSize2D();
        }
    }

    Font getFont() {
        if (this.font == null && this.fontFamily != null) {
            this.font = FontUtil.getFont(this.fontFamily, this.flags & 0xF, this.fontSize);
        }
        return this.font;
    }

    public PlotObject clone() {
        try {
            return (PlotObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

