/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.ResultsTable;
import ij.plugin.PointToolOptions;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.util.Java2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class PointRoi
extends PolygonRoi {
    public static final String[] sizes = new String[]{"Tiny", "Small", "Medium", "Large", "Extra Large"};
    public static final String[] types = new String[]{"Hybrid", "Crosshair", "Dot", "Circle"};
    private static final String TYPE_KEY = "point.type";
    private static final String SIZE_KEY = "point.size";
    private static final String CROSS_COLOR_KEY = "point.cross.color";
    private static final int TINY = 1;
    private static final int SMALL = 3;
    private static final int MEDIUM = 5;
    private static final int LARGE = 7;
    private static final int EXTRA_LARGE = 11;
    private static final int HYBRID = 0;
    private static final int CROSSHAIR = 1;
    private static final int DOT = 2;
    private static final int CIRCLE = 3;
    private static final BasicStroke twoPixelsWide = new BasicStroke(2.0f);
    private static final BasicStroke threePixelsWide = new BasicStroke(3.0f);
    private static int defaultType = 0;
    private static int defaultSize = 3;
    private static Font font;
    private static Color defaultCrossColor;
    private static int fontSize;
    public static final int MAX_COUNTERS = 100;
    private static String[] counterChoices;
    private static Color[] colors;
    private boolean showLabels;
    private int type = 0;
    private int size = 3;
    private static int defaultCounter;
    private int counter;
    private int nCounters = 1;
    private short[] counters;
    private short[] positions;
    private int[] counts = new int[100];
    private ResultsTable rt;
    private long lastPointTime;
    private int[] counterInfo;
    private boolean promptBeforeDeleting;
    private boolean promptBeforeDeletingCalled;

    public PointRoi(int[] ox, int[] oy, int points) {
        super(PointRoi.itof(ox), PointRoi.itof(oy), points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(float[] ox, float[] oy, int points) {
        super(ox, oy, points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(float[] ox, float[] oy) {
        this(ox, oy, ox.length);
    }

    public PointRoi(FloatPolygon poly) {
        this(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public PointRoi(Polygon poly) {
        this(PointRoi.itof(poly.xpoints), PointRoi.itof(poly.ypoints), poly.npoints);
    }

    public PointRoi(int ox, int oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
        this.incrementCounter(null);
    }

    public PointRoi(double ox, double oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
        this.incrementCounter(null);
    }

    public PointRoi(int sx, int sy, ImagePlus imp) {
        super(PointRoi.makeXArray(sx, imp), PointRoi.makeYArray(sy, imp), 1, 10);
        defaultCounter = 0;
        this.setImage(imp);
        this.width = 1;
        this.height = 1;
        this.type = defaultType;
        this.size = defaultSize;
        boolean bl = this.showLabels = !Prefs.noPointLabels;
        if (imp != null) {
            double mag;
            int r = 10;
            double d = mag = this.ic != null ? this.ic.getMagnification() : 1.0;
            if (mag < 1.0) {
                r = (int)((double)r / mag);
            }
            imp.draw(this.x - r, this.y - r, 2 * r, 2 * r);
        }
        this.setCounter(Toolbar.getMultiPointMode() ? defaultCounter : 0);
        this.incrementCounter(imp);
        this.enlargeArrays(50);
        if (Recorder.record && !Recorder.scriptMode()) {
            Recorder.record("makePoint", this.x, this.y);
        }
    }

    static float[] itof(int[] arr) {
        if (arr == null) {
            return null;
        }
        int n = arr.length;
        float[] temp = new float[n];
        for (int i = 0; i < n; ++i) {
            temp[i] = arr[i];
        }
        return temp;
    }

    static float[] makeXArray(double value, ImagePlus imp) {
        float[] array = new float[]{(float)(imp != null ? imp.getCanvas().offScreenXD((int)value) : value)};
        return array;
    }

    static float[] makeYArray(double value, ImagePlus imp) {
        float[] array = new float[]{(float)(imp != null ? imp.getCanvas().offScreenYD((int)value) : value)};
        return array;
    }

    void handleMouseMove(int ox, int oy) {
    }

    @Override
    protected void handleMouseUp(int sx, int sy) {
        super.handleMouseUp(sx, sy);
        this.modifyRoi();
    }

    @Override
    public void draw(Graphics g) {
        int slice;
        this.updatePolygon();
        if (this.showLabels && this.nPoints > 1) {
            fontSize = 8;
            if ((fontSize += PointRoi.convertSizeToIndex(this.size)) > 18) {
                fontSize = 18;
            }
            fontSize = Math.round(fontSize);
            font = new Font("SansSerif", 0, fontSize);
            g.setFont(font);
            if (fontSize > 9) {
                Java2.setAntialiasedText(g, true);
            }
        }
        int n = slice = this.imp != null && this.positions != null && this.imp.getStackSize() > 1 ? this.imp.getCurrentSlice() : 0;
        if (Prefs.showAllPoints) {
            slice = 0;
        }
        for (int i = 0; i < this.nPoints; ++i) {
            if (slice != 0 && slice != this.positions[i]) continue;
            this.drawPoint(g, this.xp2[i], this.yp2[i], i + 1);
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        PointToolOptions.update();
        this.flattenScale = 1.0;
    }

    void drawPoint(Graphics g, int x, int y, int n) {
        Color color;
        int size2 = this.size / 2;
        boolean colorSet = false;
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform saveXform = null;
        if (this.flattenScale > 1.0) {
            saveXform = g2d.getTransform();
            g2d.translate(x, y);
            g2d.scale(this.flattenScale, this.flattenScale);
            y = 0;
            x = 0;
        }
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (!this.overlay && this.isActiveOverlayRoi()) {
            color = color == Color.cyan ? Color.magenta : Color.cyan;
        }
        if (this.nCounters > 1 && this.counters != null && n <= this.counters.length) {
            color = PointRoi.getColor(this.counters[n - 1]);
        }
        if (this.type == 0 || this.type == 1) {
            if (this.type == 0) {
                g.setColor(Color.white);
            } else {
                g.setColor(color);
                colorSet = true;
            }
            if (this.size > 7) {
                g2d.setStroke(threePixelsWide);
            }
            g.drawLine(x - (this.size + 2), y, x + this.size + 2, y);
            g.drawLine(x, y - (this.size + 2), x, y + this.size + 2);
        }
        if (this.type != 1 && this.size > 3) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.type == 0 || this.type == 2) {
            if (!colorSet) {
                g.setColor(color);
                colorSet = true;
            }
            if (this.size > 7) {
                g2d.setStroke(onePixelWide);
            }
            if (this.size > 7 && this.type == 2) {
                g.fillOval(x - size2, y - size2, this.size, this.size);
            } else if (this.size > 7 && this.type == 0) {
                g.fillRect(x - (size2 - 2), y - (size2 - 2), this.size - 4, this.size - 4);
            } else if (this.size > 3 && this.type == 0) {
                g.fillRect(x - (size2 - 1), y - (size2 - 1), this.size - 2, this.size - 2);
            } else {
                g.fillRect(x - size2, y - size2, this.size, this.size);
            }
        }
        if (this.showLabels && this.nPoints > 1) {
            int offset = (int)Math.round(0.4);
            if (offset < 1) {
                offset = 1;
            }
            ++offset;
            if (this.nCounters == 1) {
                if (!colorSet) {
                    g.setColor(color);
                }
                g.drawString("" + n, x + offset, y + offset + fontSize);
            } else if (this.counters != null) {
                g.setColor(PointRoi.getColor(this.counters[n - 1]));
                g.drawString("" + this.counters[n - 1], x + offset, y + offset + fontSize);
            }
        }
        if (!(this.size <= 1 && this.type != 2 || this.type != 0 && this.type != 2)) {
            g.setColor(Color.black);
            if (this.size > 7 && this.type == 0) {
                g.drawOval(x - (size2 - 1), y - (size2 - 1), this.size - 3, this.size - 3);
            } else if (this.size > 3 && this.type == 0) {
                g.drawOval(x - size2, y - size2, this.size - 1, this.size - 1);
            } else {
                g.drawOval(x - (size2 + 1), y - (size2 + 1), this.size + 1, this.size + 1);
            }
        }
        if (this.type == 3) {
            int scaledSize = Math.round(this.size + 1);
            g.setColor(color);
            if (this.size > 7) {
                g2d.setStroke(twoPixelsWide);
            }
            g.drawOval(x - scaledSize / 2, y - scaledSize / 2, scaledSize, scaledSize);
        }
        if (saveXform != null) {
            g2d.setTransform(saveXform);
        }
    }

    @Override
    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(Analyzer.markWidth);
        for (int i = 0; i < this.nPoints; ++i) {
            ip.moveTo(this.x + (int)this.xpf[i], this.y + (int)this.ypf[i]);
            ip.lineTo(this.x + (int)this.xpf[i], this.y + (int)this.ypf[i]);
        }
    }

    public void addPoint(ImagePlus imp, double ox, double oy) {
        if (this.nPoints == this.xpf.length) {
            this.enlargeArrays();
        }
        this.addPoint2(imp, ox, oy);
        this.resetBoundingRect();
        ++this.width;
        ++this.height;
    }

    private void addPoint2(ImagePlus imp, double ox, double oy) {
        double xbase = this.getXBase();
        double ybase = this.getYBase();
        this.xpf[this.nPoints] = (float)(ox - xbase);
        this.ypf[this.nPoints] = (float)(oy - ybase);
        this.xp2[this.nPoints] = (int)ox;
        this.yp2[this.nPoints] = (int)oy;
        ++this.nPoints;
        this.incrementCounter(imp);
        this.lastPointTime = System.currentTimeMillis();
    }

    public PointRoi addPoint(double x, double y) {
        this.addPoint(this.getImage(), x, y);
        return this;
    }

    @Override
    protected void deletePoint(int index) {
        super.deletePoint(index);
        if (index >= 0 && index <= this.nPoints && this.counters != null) {
            short s = this.counters[index];
            this.counts[s] = this.counts[s] - 1;
            for (int i = index; i < this.nPoints; ++i) {
                this.counters[i] = this.counters[i + 1];
                this.positions[i] = this.positions[i + 1];
            }
            if (this.rt != null && WindowManager.getFrame(this.getCountsTitle()) != null) {
                this.displayCounts();
            }
        }
    }

    private synchronized void incrementCounter(ImagePlus imp) {
        boolean isStack;
        int n = this.counter;
        this.counts[n] = this.counts[n] + 1;
        boolean bl = isStack = imp != null && imp.getStackSize() > 1;
        if (this.counter != 0 || isStack || this.counters != null) {
            if (this.counters == null) {
                this.counters = new short[this.nPoints * 2];
                this.positions = new short[this.nPoints * 2];
            }
            this.counters[this.nPoints - 1] = (short)this.counter;
            if (imp != null) {
                short s = this.positions[this.nPoints - 1] = imp.getStackSize() > 1 ? (short)imp.getCurrentSlice() : (short)0;
            }
            if (this.nPoints + 1 == this.counters.length) {
                short[] temp = new short[this.counters.length * 2];
                System.arraycopy(this.counters, 0, temp, 0, this.counters.length);
                this.counters = temp;
                temp = new short[this.counters.length * 2];
                System.arraycopy(this.positions, 0, temp, 0, this.positions.length);
                this.positions = temp;
            }
        }
        if (this.rt != null && WindowManager.getFrame(this.getCountsTitle()) != null) {
            this.displayCounts();
        }
    }

    public void resetCounters() {
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = 0;
        }
        this.counters = null;
        this.positions = null;
        PointToolOptions.update();
    }

    public PointRoi subtractPoints(Roi roi) {
        Polygon points = this.getPolygon();
        Polygon poly = roi.getPolygon();
        Polygon points2 = new Polygon();
        for (int i = 0; i < points.npoints; ++i) {
            if (poly.contains(points.xpoints[i], points.ypoints[i])) continue;
            points2.addPoint(points.xpoints[i], points.ypoints[i]);
        }
        if (points2.npoints == 0) {
            return null;
        }
        return new PointRoi(points2.xpoints, points2.ypoints, points2.npoints);
    }

    @Override
    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        for (int i = 0; i < this.nPoints; ++i) {
            ((ImageProcessor)mask).putPixel(Math.round(this.xpf[i]), Math.round(this.ypf[i]), 255);
        }
        this.cachedMask = mask;
        return mask;
    }

    @Override
    public boolean contains(int x, int y) {
        for (int i = 0; i < this.nPoints; ++i) {
            if ((float)x != (float)this.x + this.xpf[i] || (float)y != (float)this.y + this.ypf[i]) continue;
            return true;
        }
        return false;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public static void setDefaultType(int type) {
        if (type >= 0 && type < types.length) {
            defaultType = type;
            PointRoi instance = PointRoi.getPointRoiInstance();
            if (instance != null) {
                instance.setPointType(defaultType);
            }
            Prefs.set(TYPE_KEY, type);
        }
    }

    public static int getDefaultType() {
        return defaultType;
    }

    public void setPointType(int type) {
        if (type >= 0 && type < types.length) {
            this.type = type;
        }
    }

    public int getPointType() {
        return this.type;
    }

    public static void setDefaultSize(int index) {
        if (index >= 0 && index < sizes.length) {
            defaultSize = PointRoi.convertIndexToSize(index);
            PointRoi instance = PointRoi.getPointRoiInstance();
            if (instance != null) {
                instance.setSize(index);
            }
            Prefs.set(SIZE_KEY, index);
        }
    }

    public static int getDefaultSize() {
        return PointRoi.convertSizeToIndex(defaultSize);
    }

    public void setSize(int size) {
        if (size >= 0 && size < sizes.length) {
            this.size = PointRoi.convertIndexToSize(size);
        }
    }

    public int getSize() {
        return PointRoi.convertSizeToIndex(this.size);
    }

    private static int convertSizeToIndex(int size) {
        switch (size) {
            case 1: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 11: {
                return 4;
            }
        }
        return 1;
    }

    private static int convertIndexToSize(int index) {
        switch (index) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 11;
            }
        }
        return 3;
    }

    public static void setDefaultCrossColor(Color color) {
    }

    public static Color getDefaultCrossColor() {
        return null;
    }

    @Override
    public boolean subPixelResolution() {
        return true;
    }

    private static PointRoi getPointRoiInstance() {
        Roi roi;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) != null && roi instanceof PointRoi) {
            return (PointRoi)roi;
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.nPoints > 1) {
            return "Roi[Points, count=" + this.nPoints + "]";
        }
        return "Roi[Point, x=" + this.x + ", y=" + this.y + "]";
    }

    public void setCounter(int counter) {
        this.counter = counter;
        if (counter > this.nCounters - 1 && this.nCounters < 100) {
            this.nCounters = counter + 1;
        }
    }

    public int getCounter() {
        return this.counter;
    }

    public int getNCounters() {
        int n = 0;
        for (int counter = 0; counter < this.nCounters; ++counter) {
            if (this.getCount(counter) <= 0) continue;
            ++n;
        }
        return n;
    }

    public boolean promptBeforeDeleting() {
        if (this.promptBeforeDeletingCalled) {
            return this.promptBeforeDeleting;
        }
        return this.getNCounters() > 1 || this.counts[0] > 1;
    }

    public void promptBeforeDeleting(Boolean prompt) {
        this.promptBeforeDeleting = prompt;
        this.promptBeforeDeletingCalled = true;
    }

    public static void setDefaultCounter(int counter) {
        defaultCounter = counter;
    }

    public int getCount(int counter) {
        if (counter == 0 && this.counters == null) {
            return this.nPoints;
        }
        return this.counts[counter];
    }

    public int getCounter(int index) {
        if (this.counters == null || index >= this.counters.length) {
            return 0;
        }
        return this.counters[index];
    }

    public int[] getCounters() {
        if (this.nPoints > 65535) {
            return null;
        }
        int[] temp = new int[this.nPoints];
        if (this.counters != null) {
            for (int i = 0; i < this.nPoints; ++i) {
                temp[i] = (this.counters[i] & 0xFF) + ((this.positions[i] & 0xFFFF) << 8);
            }
        }
        return temp;
    }

    public void setCounters(int[] counters) {
        if (counters != null) {
            int n = counters.length;
            this.counters = new short[n * 2];
            this.positions = new short[n * 2];
            for (int i = 0; i < n; ++i) {
                int counter = counters[i] & 0xFF;
                int position = counters[i] >> 8 & 0xFFFF;
                this.counters[i] = (short)counter;
                this.positions[i] = (short)position;
                if (counter >= this.counts.length) continue;
                int n2 = counter;
                this.counts[n2] = this.counts[n2] + 1;
                if (counter <= this.nCounters - 1) continue;
                this.nCounters = counter + 1;
            }
            IJ.setTool("multi-point");
        }
    }

    public int getPointPosition(int index) {
        if (this.positions != null && index < this.nPoints) {
            return this.positions[index];
        }
        return 0;
    }

    public void displayCounts() {
        ImagePlus imp = this.getImage();
        String firstColumnHdr = "Slice";
        this.rt = new ResultsTable();
        int row = 0;
        if (imp != null && imp.getStackSize() > 1 && this.positions != null) {
            int nChannels = 1;
            int nSlices = 1;
            int nFrames = 1;
            boolean isHyperstack = false;
            if (imp.isComposite() || imp.isHyperStack()) {
                isHyperstack = true;
                nChannels = imp.getNChannels();
                nSlices = imp.getNSlices();
                nFrames = imp.getNFrames();
                int nDimensions = 2;
                if (nChannels > 1) {
                    ++nDimensions;
                }
                if (nSlices > 1) {
                    ++nDimensions;
                }
                if (nFrames > 1) {
                    ++nDimensions;
                }
                if (nDimensions == 3) {
                    isHyperstack = false;
                    if (nChannels > 1) {
                        firstColumnHdr = "Channel";
                    }
                } else {
                    firstColumnHdr = "Image";
                }
            }
            int firstSlice = Integer.MAX_VALUE;
            for (int i = 0; i < this.nPoints; ++i) {
                if (this.positions[i] <= 0 || this.positions[i] >= firstSlice) continue;
                firstSlice = this.positions[i];
            }
            if (firstSlice == Integer.MAX_VALUE) {
                firstSlice = 0;
            }
            int lastSlice = 0;
            if (firstSlice > 0) {
                for (int i = 0; i < this.nPoints; ++i) {
                    if (this.positions[i] <= lastSlice) continue;
                    lastSlice = this.positions[i];
                }
            }
            if (firstSlice > 0) {
                for (int slice = firstSlice; slice <= lastSlice; ++slice) {
                    this.rt.setValue(firstColumnHdr, row, (double)slice);
                    if (isHyperstack) {
                        int[] position = imp.convertIndexToPosition(slice);
                        if (nChannels > 1) {
                            this.rt.setValue("Channel", row, (double)position[0]);
                        }
                        if (nSlices > 1) {
                            this.rt.setValue("Slice", row, (double)position[1]);
                        }
                        if (nFrames > 1) {
                            this.rt.setValue("Frame", row, (double)position[2]);
                        }
                    }
                    for (int counter = 0; counter < this.nCounters; ++counter) {
                        int count = 0;
                        for (int i = 0; i < this.nPoints; ++i) {
                            if (slice != this.positions[i] || counter != this.counters[i]) continue;
                            ++count;
                        }
                        this.rt.setValue("Ctr " + counter, row, (double)count);
                    }
                    ++row;
                }
            }
        }
        this.rt.setValue(firstColumnHdr, row, "Total");
        for (int i = 0; i < this.nCounters; ++i) {
            this.rt.setValue("Ctr " + i, row, (double)this.counts[i]);
        }
        this.rt.show(this.getCountsTitle());
        if (IJ.debugMode) {
            this.debug();
        }
    }

    private void debug() {
        FloatPolygon p = this.getFloatPolygon();
        ResultsTable rt = new ResultsTable();
        for (int i = 0; i < this.nPoints; ++i) {
            if (this.counters != null) {
                rt.setValue("Counter", i, (double)this.counters[i]);
                rt.setValue("Position", i, (double)this.positions[i]);
            }
            rt.setValue("X", i, (double)p.xpoints[i]);
            rt.setValue("Y", i, (double)p.ypoints[i]);
        }
        rt.show(this.getCountsTitle());
    }

    private String getCountsTitle() {
        return "Counts_" + (this.imp != null ? this.imp.getTitle() : "");
    }

    public static synchronized String[] getCounterChoices() {
        if (counterChoices == null) {
            counterChoices = new String[100];
            for (int i = 0; i < 100; ++i) {
                PointRoi.counterChoices[i] = "" + i;
            }
        }
        return counterChoices;
    }

    private static Color getColor(int index) {
        Color c;
        if (colors == null) {
            colors = new Color[100];
            PointRoi.colors[0] = Color.yellow;
            PointRoi.colors[1] = Color.magenta;
            PointRoi.colors[2] = Color.cyan;
            PointRoi.colors[3] = Color.orange;
            PointRoi.colors[4] = Color.green;
            PointRoi.colors[5] = Color.blue;
            PointRoi.colors[6] = Color.white;
            PointRoi.colors[7] = Color.darkGray;
            PointRoi.colors[8] = Color.pink;
            PointRoi.colors[9] = Color.lightGray;
        }
        if (colors[index] != null) {
            return colors[index];
        }
        Random ran = new Random();
        float r = (float)ran.nextDouble();
        float g = (float)ran.nextDouble();
        float b = (float)ran.nextDouble();
        PointRoi.colors[index] = c = new Color(r, g, b);
        return c;
    }

    @Override
    public int isHandle(int sx, int sy) {
        if (System.currentTimeMillis() - this.lastPointTime < 1000L) {
            return -1;
        }
        int size = 5 + this.size;
        int halfSize = size / 2;
        int handle = -1;
        int slice = !Prefs.showAllPoints && this.positions != null && this.imp != null && this.imp.getStackSize() > 1 ? this.imp.getCurrentSlice() : 0;
        for (int i = 0; i < this.nPoints; ++i) {
            if (slice != 0 && slice != this.positions[i]) continue;
            int sx2 = this.xp2[i] - halfSize;
            int sy2 = this.yp2[i] - halfSize;
            if (sx < sx2 || sx > sx2 + size || sy < sy2 || sy > sy2 + size) continue;
            handle = i;
            break;
        }
        return handle;
    }

    @Override
    public Point[] getContainedPoints() {
        FloatPolygon p = this.getFloatPolygon();
        Point[] points = new Point[p.npoints];
        for (int i = 0; i < p.npoints; ++i) {
            points[i] = new Point(Math.round(p.xpoints[i] - 0.5f), Math.round(p.ypoints[i] - 0.5f));
        }
        return points;
    }

    @Override
    public FloatPolygon getContainedFloatPoints() {
        return this.getFloatPolygon();
    }

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            final Point[] pnts;
            final int n;
            int next;
            {
                this.pnts = PointRoi.this.getContainedPoints();
                this.n = this.pnts.length;
                this.next = this.n == 0 ? 1 : 0;
            }

            @Override
            public boolean hasNext() {
                return this.next < this.n;
            }

            @Override
            public Point next() {
                if (this.next >= this.n) {
                    throw new NoSuchElementException();
                }
                Point pnt = this.pnts[this.next];
                ++this.next;
                return pnt;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected int getClosestPoint(double x, double y, FloatPolygon points) {
        int slice;
        int index = -1;
        double distance = Double.MAX_VALUE;
        int n = slice = this.imp != null && this.positions != null && this.imp.getStackSize() > 1 ? this.imp.getCurrentSlice() : 0;
        if (Prefs.showAllPoints) {
            slice = 0;
        }
        for (int i = 0; i < points.npoints; ++i) {
            double dx = (double)points.xpoints[i] - x;
            double dy = (double)points.ypoints[i] - y;
            double distance2 = dx * dx + dy * dy;
            if (!(distance2 < distance) || slice != 0 && slice != this.positions[i]) continue;
            distance = distance2;
            index = i;
        }
        return index;
    }

    @Override
    public synchronized Object clone() {
        int i;
        PointRoi r = (PointRoi)super.clone();
        if (this.counters != null) {
            r.counters = new short[this.counters.length];
            for (i = 0; i < this.counters.length; ++i) {
                r.counters[i] = this.counters[i];
            }
        }
        if (this.positions != null) {
            r.positions = new short[this.positions.length];
            for (i = 0; i < this.positions.length; ++i) {
                r.positions[i] = this.positions[i];
            }
        }
        if (this.counts != null) {
            r.counts = new int[this.counts.length];
            for (i = 0; i < this.counts.length; ++i) {
                r.counts[i] = this.counts[i];
            }
        }
        return r;
    }

    public void setCounterInfo(int[] info) {
        this.counterInfo = info;
    }

    public int[] getCounterInfo() {
        return this.counterInfo;
    }

    public void setHideLabels(boolean hideLabels) {
        this.showLabels = !hideLabels;
    }

    public static void setDefaultMarkerSize(String size) {
    }

    public static String getDefaultMarkerSize() {
        return sizes[defaultSize];
    }

    static {
        defaultCrossColor = Color.white;
        fontSize = 9;
        PointRoi.setDefaultType((int)Prefs.get(TYPE_KEY, 0.0));
        PointRoi.setDefaultSize((int)Prefs.get(SIZE_KEY, 1.0));
    }
}

