/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.elements;

import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.java.dev.webdav.jaxrs.xml.elements.LockScope;
import net.java.dev.webdav.jaxrs.xml.elements.LockType;
import net.java.dev.webdav.jaxrs.xml.elements.Owner;
import net.java.dev.webdav.util.Utilities;

@XmlType(propOrder={"lockScope", "lockType", "owner"})
@XmlRootElement(name="lockinfo")
public final class LockInfo {
    @XmlElement(name="lockscope")
    private final LockScope lockScope;
    @XmlElement(name="locktype")
    private final LockType lockType;
    @XmlElement
    private final Owner owner;

    private LockInfo() {
        this.lockScope = null;
        this.lockType = null;
        this.owner = null;
    }

    public LockInfo(LockScope lockScope, LockType lockType, Owner owner) {
        this.lockScope = Utilities.notNull(lockScope, "lockScope");
        this.lockType = Utilities.notNull(lockType, "lockType");
        this.owner = owner;
    }

    public final LockScope getLockScope() {
        return this.lockScope;
    }

    public final LockType getLockType() {
        return this.lockType;
    }

    public final Owner getOwner() {
        return this.owner;
    }

    public final int hashCode() {
        return Objects.hash(this.lockScope, this.lockType, this.owner);
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LockInfo)) {
            return false;
        }
        LockInfo that = (LockInfo)other;
        return Arrays.equals(Utilities.array(this.lockScope, this.lockType, this.owner), Utilities.array(that.lockScope, that.lockType, that.owner));
    }

    public final String toString() {
        return Utilities.toString(this, this.lockScope, this.lockType, this.owner);
    }
}

