/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.annotations.processing;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import net.java.truecommons.annotations.ServiceSpecification;
import net.java.truecommons.annotations.processing.ServiceProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"*"})
public final class ServiceSpecificationProcessor
extends ServiceProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceSpecification.class)) {
            TypeElement spec = (TypeElement)element;
            this.valid(spec, spec);
        }
        return false;
    }

    boolean valid(TypeElement spec, Element loc) {
        Set<Modifier> modifiers = spec.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.FINAL)) {
            return this.error("Not a public and non-final class or interface.", loc);
        }
        if (spec.getNestingKind().isNested()) {
            if (!modifiers.contains((Object)Modifier.STATIC)) {
                return this.error("Impossible to implement outside of the lexical scope of the enclosing class.", loc);
            }
            this.warning("Bad practice: Not a top-level class or interface.", loc);
        }
        LinkedList<ExecutableElement> ctors = new LinkedList<ExecutableElement>();
        for (Element element : spec.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ctors.add((ExecutableElement)element);
        }
        return ctors.isEmpty() || this.valid(ctors) || this.error("No public or protected constructor with zero parameters available.", loc);
    }

    private boolean valid(Collection<ExecutableElement> ctors) {
        for (ExecutableElement ctor : ctors) {
            if (!this.valid(ctor)) continue;
            return true;
        }
        return false;
    }

    private boolean valid(ExecutableElement ctor) {
        return (ctor.getModifiers().contains((Object)Modifier.PUBLIC) || ctor.getModifiers().contains((Object)Modifier.PROTECTED)) && ctor.getParameters().isEmpty();
    }
}

