/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.annotation.Nullable;

public interface LockingTaskExecutor {
    public void executeWithLock(Runnable var1, LockConfiguration var2);

    public void executeWithLock(Task var1, LockConfiguration var2) throws Throwable;

    default public <T> TaskResult<T> executeWithLock(TaskWithResult<T> task, LockConfiguration lockConfig) throws Throwable {
        throw new UnsupportedOperationException();
    }

    public static final class TaskResult<T> {
        private final boolean executed;
        @Nullable
        private final T result;

        private TaskResult(boolean executed, @Nullable T result) {
            this.executed = executed;
            this.result = result;
        }

        public boolean wasExecuted() {
            return this.executed;
        }

        @Nullable
        public T getResult() {
            return this.result;
        }

        static <T> TaskResult<T> result(@Nullable T result) {
            return new TaskResult<T>(true, result);
        }

        static <T> TaskResult<T> notExecuted() {
            return new TaskResult<Object>(false, null);
        }
    }

    @FunctionalInterface
    public static interface TaskWithResult<T> {
        @Nullable
        public T call() throws Throwable;
    }

    @FunctionalInterface
    public static interface Task {
        public void call() throws Throwable;
    }
}

