/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class JdbcTemplateStorageAccessor
extends AbstractStorageAccessor {
    private final String tableName;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final TimeZone timeZone;

    JdbcTemplateStorageAccessor(JdbcTemplateLockProvider.Configuration configuration) {
        this.jdbcTemplate = Objects.requireNonNull(configuration.getJdbcTemplate(), "jdbcTemplate can not be null");
        this.tableName = Objects.requireNonNull(configuration.getTableName(), "tableName can not be null");
        PlatformTransactionManager transactionManager = configuration.getTransactionManager() != null ? configuration.getTransactionManager() : new DataSourceTransactionManager(this.jdbcTemplate.getDataSource());
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
        this.timeZone = configuration.getTimeZone();
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        String sql = "INSERT INTO " + this.tableName + "(name, lock_until, locked_at, locked_by) VALUES(?, ?, ?, ?)";
        return (Boolean)this.transactionTemplate.execute(status -> {
            try {
                int insertedRows = this.jdbcTemplate.update(sql, preparedStatement -> {
                    preparedStatement.setString(1, lockConfiguration.getName());
                    this.setTimestamp(preparedStatement, 2, lockConfiguration.getLockAtMostUntil());
                    this.setTimestamp(preparedStatement, 3, Instant.now());
                    preparedStatement.setString(4, this.getHostname());
                });
                return insertedRows > 0;
            }
            catch (DuplicateKeyException e) {
                return false;
            }
            catch (DataIntegrityViolationException e) {
                this.logger.warn("Unexpected exception", (Throwable)e);
                return false;
            }
        });
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ?, locked_at = ?, locked_by = ? WHERE name = ? AND lock_until <= ?";
        return (Boolean)this.transactionTemplate.execute(status -> {
            int updatedRows = this.jdbcTemplate.update(sql, statement -> {
                Instant now = Instant.now();
                this.setTimestamp(statement, 1, lockConfiguration.getLockAtMostUntil());
                this.setTimestamp(statement, 2, now);
                statement.setString(3, this.getHostname());
                statement.setString(4, lockConfiguration.getName());
                this.setTimestamp(statement, 5, now);
            });
            return updatedRows > 0;
        });
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ? WHERE name = ? AND locked_by = ? AND lock_until > ? ";
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return (Boolean)this.transactionTemplate.execute(status -> {
            int updatedRows = this.jdbcTemplate.update(sql, statement -> {
                this.setTimestamp(statement, 1, lockConfiguration.getLockAtMostUntil());
                statement.setString(2, lockConfiguration.getName());
                statement.setString(3, this.getHostname());
                this.setTimestamp(statement, 4, Instant.now());
            });
            return updatedRows > 0;
        });
    }

    private void setTimestamp(PreparedStatement preparedStatement, int parameterIndex, Instant time) throws SQLException {
        if (this.timeZone == null) {
            preparedStatement.setTimestamp(parameterIndex, Timestamp.from(time));
        } else {
            preparedStatement.setTimestamp(parameterIndex, Timestamp.from(time), Calendar.getInstance(this.timeZone));
        }
    }

    public void unlock(final LockConfiguration lockConfiguration) {
        final String sql = "UPDATE " + this.tableName + " SET lock_until = ? WHERE name = ?";
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JdbcTemplateStorageAccessor.this.jdbcTemplate.update(sql, statement -> {
                    JdbcTemplateStorageAccessor.this.setTimestamp(statement, 1, lockConfiguration.getUnlockTime());
                    statement.setString(2, lockConfiguration.getName());
                });
            }
        });
    }
}

