/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.Objects;
import java.util.TimeZone;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.DatabaseProduct;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateStorageAccessor;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import net.javacrumbs.shedlock.support.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateLockProvider
extends StorageBasedLockProvider {
    private static final String DEFAULT_TABLE_NAME = "shedlock";

    public JdbcTemplateLockProvider(@NonNull JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, (PlatformTransactionManager)null);
    }

    public JdbcTemplateLockProvider(@NonNull JdbcTemplate jdbcTemplate, @Nullable PlatformTransactionManager transactionManager) {
        this(jdbcTemplate, transactionManager, DEFAULT_TABLE_NAME);
    }

    public JdbcTemplateLockProvider(@NonNull JdbcTemplate jdbcTemplate, @NonNull String tableName) {
        this(jdbcTemplate, null, tableName);
    }

    public JdbcTemplateLockProvider(@NonNull DataSource dataSource) {
        this(new JdbcTemplate(dataSource));
    }

    public JdbcTemplateLockProvider(@NonNull DataSource dataSource, @NonNull String tableName) {
        this(new JdbcTemplate(dataSource), tableName);
    }

    public JdbcTemplateLockProvider(@NonNull JdbcTemplate jdbcTemplate, @Nullable PlatformTransactionManager transactionManager, @NonNull String tableName) {
        this(Configuration.builder().withJdbcTemplate(jdbcTemplate).withTransactionManager(transactionManager).withTableName(tableName).build());
    }

    public JdbcTemplateLockProvider(@NonNull Configuration configuration) {
        super((StorageAccessor)new JdbcTemplateStorageAccessor(configuration));
    }

    public static final class Configuration {
        private final JdbcTemplate jdbcTemplate;
        private final DatabaseProduct databaseProduct;
        private final PlatformTransactionManager transactionManager;
        private final String tableName;
        private final TimeZone timeZone;
        private final ColumnNames columnNames;
        private final String lockedByValue;
        private final boolean useDbTime;
        private final Integer isolationLevel;
        private final boolean throwUnexpectedException;

        Configuration(@NonNull JdbcTemplate jdbcTemplate, @Nullable DatabaseProduct databaseProduct, @Nullable PlatformTransactionManager transactionManager, @NonNull String tableName, @Nullable TimeZone timeZone, @NonNull ColumnNames columnNames, @NonNull String lockedByValue, boolean useDbTime, @Nullable Integer isolationLevel, boolean throwUnexpectedException) {
            this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate can not be null");
            this.databaseProduct = databaseProduct;
            this.transactionManager = transactionManager;
            this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
            this.timeZone = timeZone;
            this.columnNames = Objects.requireNonNull(columnNames, "columnNames can not be null");
            this.lockedByValue = Objects.requireNonNull(lockedByValue, "lockedByValue can not be null");
            this.isolationLevel = isolationLevel;
            if (useDbTime && timeZone != null) {
                throw new IllegalArgumentException("Can not set both useDbTime and timeZone");
            }
            this.useDbTime = useDbTime;
            this.throwUnexpectedException = throwUnexpectedException;
        }

        public JdbcTemplate getJdbcTemplate() {
            return this.jdbcTemplate;
        }

        public DatabaseProduct getDatabaseProduct() {
            return this.databaseProduct;
        }

        public PlatformTransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public String getTableName() {
            return this.tableName;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public ColumnNames getColumnNames() {
            return this.columnNames;
        }

        public String getLockedByValue() {
            return this.lockedByValue;
        }

        public boolean getUseDbTime() {
            return this.useDbTime;
        }

        public Integer getIsolationLevel() {
            return this.isolationLevel;
        }

        public boolean isThrowUnexpectedException() {
            return this.throwUnexpectedException;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private JdbcTemplate jdbcTemplate;
            private DatabaseProduct databaseProduct;
            private PlatformTransactionManager transactionManager;
            private String tableName = "shedlock";
            private TimeZone timeZone;
            private String lockedByValue = Utils.getHostname();
            private ColumnNames columnNames = new ColumnNames("name", "lock_until", "locked_at", "locked_by");
            private boolean dbUpperCase = false;
            private boolean useDbTime = false;
            private Integer isolationLevel;
            private boolean throwUnexpectedException = false;

            public Builder withJdbcTemplate(@NonNull JdbcTemplate jdbcTemplate) {
                this.jdbcTemplate = jdbcTemplate;
                return this;
            }

            public Builder withTransactionManager(PlatformTransactionManager transactionManager) {
                this.transactionManager = transactionManager;
                return this;
            }

            public Builder withTableName(@NonNull String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder withTimeZone(TimeZone timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public Builder withColumnNames(ColumnNames columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            public Builder withDbUpperCase(boolean dbUpperCase) {
                this.dbUpperCase = dbUpperCase;
                return this;
            }

            public Builder withDatabaseProduct(DatabaseProduct databaseProduct) {
                this.databaseProduct = databaseProduct;
                return this;
            }

            public Builder withLockedByValue(String lockedBy) {
                this.lockedByValue = lockedBy;
                return this;
            }

            public Builder usingDbTime() {
                this.useDbTime = true;
                return this;
            }

            public Builder withIsolationLevel(int isolationLevel) {
                this.isolationLevel = isolationLevel;
                return this;
            }

            public Builder withThrowUnexpectedException(boolean throwUnexpectedException) {
                this.throwUnexpectedException = throwUnexpectedException;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.jdbcTemplate, this.databaseProduct, this.transactionManager, this.dbUpperCase ? this.tableName.toUpperCase() : this.tableName, this.timeZone, this.dbUpperCase ? this.columnNames.toUpperCase() : this.columnNames, this.lockedByValue, this.useDbTime, this.isolationLevel, this.throwUnexpectedException);
            }
        }
    }

    public static final class ColumnNames {
        private final String name;
        private final String lockUntil;
        private final String lockedAt;
        private final String lockedBy;

        public ColumnNames(String name, String lockUntil, String lockedAt, String lockedBy) {
            this.name = Objects.requireNonNull(name, "'name' column name can not be null");
            this.lockUntil = Objects.requireNonNull(lockUntil, "'lockUntil' column name can not be null");
            this.lockedAt = Objects.requireNonNull(lockedAt, "'lockedAt' column name can not be null");
            this.lockedBy = Objects.requireNonNull(lockedBy, "'lockedBy' column name can not be null");
        }

        public String getName() {
            return this.name;
        }

        public String getLockUntil() {
            return this.lockUntil;
        }

        public String getLockedAt() {
            return this.lockedAt;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }

        private ColumnNames toUpperCase() {
            return new ColumnNames(this.name.toUpperCase(), this.lockUntil.toUpperCase(), this.lockedAt.toUpperCase(), this.lockedBy.toUpperCase());
        }
    }
}

