/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;

class HsqlServerTimeStatementsSource
extends SqlStatementsSource {
    private static final String now = "CURRENT_TIMESTAMP(3)";
    private static final String lockAtMostFor = "TIMESTAMPADD(MICROSECOND, :lockAtMostForMicros, CURRENT_TIMESTAMP(3))";

    HsqlServerTimeStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        super(configuration);
    }

    @Override
    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, TIMESTAMPADD(MICROSECOND, :lockAtMostForMicros, CURRENT_TIMESTAMP(3)), CURRENT_TIMESTAMP(3), :lockedBy)";
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = TIMESTAMPADD(MICROSECOND, :lockAtMostForMicros, CURRENT_TIMESTAMP(3)), " + this.lockedAt() + " = CURRENT_TIMESTAMP(3), " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= CURRENT_TIMESTAMP(3)";
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = "TIMESTAMPADD(MICROSECOND, :lockAtLeastForMicros, " + this.lockedAt() + ")";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > CURRENT_TIMESTAMP(3) THEN " + lockAtLeastFor + " ELSE CURRENT_TIMESTAMP(3) END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = TIMESTAMPADD(MICROSECOND, :lockAtMostForMicros, CURRENT_TIMESTAMP(3)) WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > CURRENT_TIMESTAMP(3)";
    }

    @Override
    Map<String, Object> params(LockConfiguration lockConfiguration) {
        return Map.of("name", lockConfiguration.getName(), "lockedBy", this.configuration.getLockedByValue(), "lockAtMostForMicros", lockConfiguration.getLockAtMostFor().toNanos() / 1000L, "lockAtLeastForMicros", lockConfiguration.getLockAtLeastFor().toNanos() / 1000L);
    }
}

