/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.DatabaseProduct;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.PostgresSqlStatementsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlStatementsSource {
    protected final JdbcTemplateLockProvider.Configuration configuration;
    private static final Logger logger = LoggerFactory.getLogger(SqlStatementsSource.class);

    SqlStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        this.configuration = configuration;
    }

    static SqlStatementsSource create(JdbcTemplateLockProvider.Configuration configuration) {
        DatabaseProduct databaseProduct = SqlStatementsSource.getDatabaseProduct(configuration);
        if (configuration.getUseDbTime()) {
            SqlStatementsSource statementsSource = databaseProduct.getDbTimeStatementSource(configuration);
            logger.debug("Using {}", (Object)statementsSource.getClass().getSimpleName());
            return statementsSource;
        }
        if (Objects.equals((Object)databaseProduct, (Object)DatabaseProduct.POSTGRES_SQL)) {
            logger.debug("Using PostgresSqlStatementsSource");
            return new PostgresSqlStatementsSource(configuration);
        }
        logger.debug("Using SqlStatementsSource");
        return new SqlStatementsSource(configuration);
    }

    private static DatabaseProduct getDatabaseProduct(JdbcTemplateLockProvider.Configuration configuration) {
        if (configuration.getDatabaseProduct() != null) {
            return configuration.getDatabaseProduct();
        }
        try {
            String jdbcProductName = (String)configuration.getJdbcTemplate().execute(connection -> connection.getMetaData().getDatabaseProductName());
            return DatabaseProduct.matchProductName(jdbcProductName);
        }
        catch (Exception e) {
            logger.debug("Can not determine database product name {}", (Object)e.getMessage());
            return DatabaseProduct.UNKNOWN;
        }
    }

    Map<String, Object> params(LockConfiguration lockConfiguration) {
        return Map.of("name", lockConfiguration.getName(), "lockUntil", this.timestamp(lockConfiguration.getLockAtMostUntil()), "now", this.timestamp(ClockProvider.now()), "lockedBy", this.configuration.getLockedByValue(), "unlockTime", this.timestamp(lockConfiguration.getUnlockTime()));
    }

    private Object timestamp(Instant time) {
        TimeZone timeZone = this.configuration.getTimeZone();
        if (timeZone == null) {
            return Timestamp.from(time);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Date.from(time));
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, :lockUntil, :now, :lockedBy)";
    }

    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil, " + this.lockedAt() + " = :now, " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= :now";
    }

    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :lockUntil WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > :now";
    }

    public String getUnlockStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = :unlockTime WHERE " + this.name() + " = :name";
    }

    String name() {
        return this.configuration.getColumnNames().getName();
    }

    String lockUntil() {
        return this.configuration.getColumnNames().getLockUntil();
    }

    String lockedAt() {
        return this.configuration.getColumnNames().getLockedAt();
    }

    String lockedBy() {
        return this.configuration.getColumnNames().getLockedBy();
    }

    String tableName() {
        return this.configuration.getTableName();
    }
}

