/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.spring;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockProvider;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockTemplate;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class ReactiveRedisLockProvider
implements LockProvider {
    private final InternalRedisLockProvider internalRedisLockProvider;

    public ReactiveRedisLockProvider(ReactiveRedisConnectionFactory redisConn) {
        this(redisConn, "default");
    }

    public ReactiveRedisLockProvider(ReactiveRedisConnectionFactory redisConn, String environment) {
        this(redisConn, environment, "job-lock");
    }

    public ReactiveRedisLockProvider(ReactiveRedisConnectionFactory redisConn, String environment, String keyPrefix) {
        this(new ReactiveStringRedisTemplate(redisConn), environment, keyPrefix);
    }

    public ReactiveRedisLockProvider(ReactiveStringRedisTemplate redisTemplate, String environment, String keyPrefix) {
        this.internalRedisLockProvider = new InternalRedisLockProvider((InternalRedisLockTemplate)new ReactiveRedisLockTemplate(redisTemplate), environment, keyPrefix, false);
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        return this.internalRedisLockProvider.lock(lockConfiguration);
    }

    private record ReactiveRedisLockTemplate(ReactiveStringRedisTemplate redisTemplate) implements InternalRedisLockTemplate
    {
        public boolean setIfAbsent(String key, String value, long expirationMs) {
            return Boolean.TRUE == this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, Duration.ofMillis(expirationMs)).block();
        }

        public boolean setIfPresent(String key, String value, long expirationMs) {
            return Boolean.TRUE == this.redisTemplate.opsForValue().setIfPresent((Object)key, (Object)value, Duration.ofMillis(expirationMs)).block();
        }

        public Object eval(String script, String key, String ... values) {
            return this.redisTemplate.execute((RedisScript)new DefaultRedisScript(script, Integer.class), List.of(key), List.of(values)).next().block();
        }

        public void delete(String key) {
            this.redisTemplate.delete((Object[])new String[]{key}).block();
        }
    }

    public static class Builder {
        private final ReactiveStringRedisTemplate redisTemplate;
        private String environment = "default";
        private String keyPrefix = "job-lock";

        public Builder(ReactiveRedisConnectionFactory redisConnectionFactory) {
            this.redisTemplate = new ReactiveStringRedisTemplate(redisConnectionFactory);
        }

        public Builder(ReactiveStringRedisTemplate redisTemplate) {
            this.redisTemplate = redisTemplate;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public ReactiveRedisLockProvider build() {
            return new ReactiveRedisLockProvider(this.redisTemplate, this.environment, this.keyPrefix);
        }
    }
}

