/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.time.Duration;
import java.util.Objects;
import net.javacrumbs.shedlock.spring.ExtendedLockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.aop.AbstractLockConfiguration;
import net.javacrumbs.shedlock.spring.aop.SpringLockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.aop.StringToDurationConverter;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringValueResolver;

@Configuration
class LockConfigurationExtractorConfiguration
extends AbstractLockConfiguration
implements EmbeddedValueResolverAware,
BeanFactoryAware {
    private final StringToDurationConverter durationConverter = StringToDurationConverter.INSTANCE;
    private @Nullable StringValueResolver resolver;
    private @Nullable BeanFactory beanFactory;

    LockConfigurationExtractorConfiguration() {
    }

    @Bean
    ExtendedLockConfigurationExtractor lockConfigurationExtractor() {
        return new SpringLockConfigurationExtractor(this.defaultLockAtMostForDuration(), this.defaultLockAtLeastForDuration(), this.resolver, this.durationConverter, this.beanFactory);
    }

    private Duration defaultLockAtLeastForDuration() {
        return this.toDuration(this.getDefaultLockAtLeastFor());
    }

    private Duration defaultLockAtMostForDuration() {
        return this.toDuration(this.getDefaultLockAtMostFor());
    }

    private String getDefaultLockAtLeastFor() {
        return this.getStringFromAnnotation("defaultLockAtLeastFor");
    }

    private String getDefaultLockAtMostFor() {
        return this.getStringFromAnnotation("defaultLockAtMostFor");
    }

    private Duration toDuration(String string) {
        String resolved;
        String string2 = resolved = this.resolver != null ? this.resolver.resolveStringValue(string) : string;
        if (resolved == null) {
            resolved = string;
        }
        return this.durationConverter.convert(resolved);
    }

    protected String getStringFromAnnotation(String name) {
        return Objects.requireNonNull(this.annotationAttributes).getString(name);
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

