/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.time.Duration;

public class ExecutionContext {
    private final Duration startTime;
    volatile int attempts;

    ExecutionContext(Duration startTime) {
        this.startTime = startTime;
    }

    private ExecutionContext(ExecutionContext context) {
        this.startTime = context.startTime;
        this.attempts = context.attempts;
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos(System.nanoTime() - this.startTime.toNanos());
    }

    public int getAttemptCount() {
        return this.attempts;
    }

    public Duration getStartTime() {
        return this.startTime;
    }

    public ExecutionContext copy() {
        return new ExecutionContext(this);
    }
}

