/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.LinkedList;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonParser$;
import net.liftweb.json.JsonParser$CloseArr$;
import net.liftweb.json.JsonParser$CloseObj$;
import net.liftweb.json.JsonParser$End$;
import net.liftweb.json.JsonParser$MArray$;
import net.liftweb.json.JsonParser$MBlock$class;
import net.liftweb.json.JsonParser$MObject$;
import net.liftweb.json.JsonParser$NullVal$;
import net.liftweb.json.JsonParser$OpenArr$;
import net.liftweb.json.JsonParser$OpenObj$;
import net.liftweb.json.JsonParser$Parser$ARRAY$;
import net.liftweb.json.JsonParser$Parser$OBJECT$;
import scala.BigInt;
import scala.BigInt$;
import scala.Function1;
import scala.List;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class JsonParser {
    public static final JsonAST.JValue parse(String string) {
        return JsonParser$.MODULE$.parse(string);
    }

    public static final int $tag() throws RemoteException {
        return JsonParser$.MODULE$.$tag();
    }

    public static class MInt
    implements MValue,
    ScalaObject,
    Product,
    Serializable {
        private final BigInt value;

        public MInt(BigInt value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd8$1(BigInt x$1) {
            BigInt bigInt = x$1;
            BigInt bigInt2 = this.value();
            return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.value();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MInt";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof MInt && this.gd8$1(((MInt)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return -1221109575;
        }

        public JsonAST.JInt toJValue() {
            return new JsonAST.JInt(this.value());
        }

        public BigInt value() {
            return this.value;
        }
    }

    public static abstract class Token
    implements ScalaObject {
        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }

    public static class MBool
    implements MValue,
    ScalaObject,
    Product,
    Serializable {
        private final boolean value;

        public MBool(boolean value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd10$1(boolean x$1) {
            return x$1 == this.value();
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return BoxesRunTime.boxToBoolean((boolean)this.value());
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MBool";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof MBool && this.gd10$1(((MBool)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 800101216;
        }

        public JsonAST.JBool toJValue() {
            return new JsonAST.JBool(this.value());
        }

        public boolean value() {
            return this.value;
        }
    }

    public static interface MValue {
        public JsonAST.JValue toJValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MArray
    implements MValue,
    MBlock<MValue>,
    ScalaObject,
    Product {
        private List elems;

        public MArray() {
            JsonParser$MBlock$class.$init$(this);
            Product.class.$init$((Product)this);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "MArray";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof MArray);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return -967497565;
        }

        @Override
        public JsonAST.JArray toJValue() {
            return new JsonAST.JArray((List<JsonAST.JValue>)this.elems().map((Function1)new MArray$$anonfun$toJValue$2(this)).reverse());
        }

        @Override
        public void $plus$eq(MValue x$1) {
            JsonParser$MBlock$class.$plus$eq(this, x$1);
        }

        @Override
        public void elems_$eq(List x$1) {
            this.elems = x$1;
        }

        @Override
        public List elems() {
            return this.elems;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MBlock<A extends MValue>
    extends ScalaObject {
        public void $plus$eq(A var1);

        public void elems_$eq(List<A> var1);

        public List<A> elems();
    }

    public static class Parser
    implements ScalaObject {
        private /* synthetic */ JsonParser$Parser$OBJECT$ OBJECT$module;
        private /* synthetic */ JsonParser$Parser$ARRAY$ ARRAY$module;
        private int cur;
        private boolean fieldNameMode;
        private final LinkedList<BlockMode> blocks;
        private final String buf;

        public Parser(String buf) {
            this.buf = buf;
            this.blocks = new LinkedList();
            this.fieldNameMode = true;
            this.cur = 0;
        }

        private final /* synthetic */ boolean gd12$1(char x$1) {
            return this.isDelimiter$1(x$1);
        }

        private final /* synthetic */ boolean gd11$1(char x$1) {
            return Character.isDigit(x$1) || x$1 == '-';
        }

        private final Product parseValue$1() {
            int i = this.cur + 1;
            boolean wasInt = true;
            boolean doubleVal = false;
            while (wasInt) {
                char c = this.buf.charAt(i);
                if (c == '.' || c == 'e' || c == 'E') {
                    doubleVal = true;
                    ++i;
                    continue;
                }
                if (Character.isDigit(c) || c == '.' || c == 'e' || c == 'E' || c == '-') {
                    ++i;
                    continue;
                }
                wasInt = false;
            }
            String value = this.buf.substring(this.cur, i);
            this.cur = i;
            return doubleVal ? new DoubleVal(Predef$.MODULE$.stringWrapper(value).toDouble()) : new IntVal(BigInt$.MODULE$.apply(value));
        }

        private final String parseString$1() {
            ++this.cur;
            StringBuilder s$1 = new StringBuilder();
            while (true) {
                StringBuilder stringBuilder;
                char c;
                if ((c = this.buf.charAt(this.cur)) == '\"') {
                    ++this.cur;
                    return s$1.toString();
                }
                if (c == '\\') {
                    ++this.cur;
                    char c2 = this.buf.charAt(this.cur);
                    switch (c2) {
                        default: {
                            stringBuilder = this.append$1('\\', s$1);
                            break;
                        }
                        case 'u': {
                            int codePoint = Integer.parseInt(this.buf.substring(this.cur + 1, this.cur + 5), 16);
                            this.cur += 4;
                            stringBuilder = s$1.appendCodePoint(codePoint);
                            break;
                        }
                        case 't': {
                            stringBuilder = this.append$1('\t', s$1);
                            break;
                        }
                        case 'r': {
                            stringBuilder = this.append$1('\r', s$1);
                            break;
                        }
                        case 'n': {
                            stringBuilder = this.append$1('\n', s$1);
                            break;
                        }
                        case 'f': {
                            stringBuilder = this.append$1('\f', s$1);
                            break;
                        }
                        case 'b': {
                            stringBuilder = this.append$1('\b', s$1);
                            break;
                        }
                        case '\\': {
                            stringBuilder = this.append$1('\\', s$1);
                            break;
                        }
                        case '/': {
                            stringBuilder = this.append$1('/', s$1);
                            break;
                        }
                        case '\"': {
                            stringBuilder = this.append$1('\"', s$1);
                            break;
                        }
                    }
                } else {
                    stringBuilder = this.append$1(c, s$1);
                }
                ++this.cur;
            }
        }

        private final StringBuilder append$1(char c, StringBuilder stringBuilder) {
            return stringBuilder.append(c);
        }

        private final String parseFieldName$1() {
            ++this.cur;
            int start = this.cur;
            while (true) {
                char c;
                if ((c = this.buf.charAt(this.cur)) == '\"') {
                    ++this.cur;
                    return this.buf.substring(start, this.cur - 1);
                }
                ++this.cur;
            }
        }

        private final boolean isDelimiter$1(char c) {
            return c == ' ' || c == '\n' || c == ',' || c == '\r' || c == '\t' || c == '}' || c == ']';
        }

        public final JsonParser$Parser$OBJECT$ OBJECT() {
            if (this.OBJECT$module == null) {
                this.OBJECT$module = new JsonParser$Parser$OBJECT$(this);
            }
            return this.OBJECT$module;
        }

        public final JsonParser$Parser$ARRAY$ ARRAY() {
            if (this.ARRAY$module == null) {
                this.ARRAY$module = new JsonParser$Parser$ARRAY$(this);
            }
            return this.ARRAY$module;
        }

        public Token nextToken() {
            int len = this.buf.length();
            while (this.cur < len) {
                char c = this.buf.charAt(this.cur);
                if (c == '{') {
                    this.blocks.addFirst(this.OBJECT());
                    ++this.cur;
                    this.fieldNameMode = true;
                    return JsonParser$OpenObj$.MODULE$;
                }
                if (c == '}') {
                    this.blocks.poll();
                    ++this.cur;
                    return JsonParser$CloseObj$.MODULE$;
                }
                if (c == '\"') {
                    if (this.fieldNameMode && BoxesRunTime.equals((Object)this.blocks.peek(), (Object)this.OBJECT())) {
                        return new FieldStart(this.parseFieldName$1());
                    }
                    this.fieldNameMode = true;
                    return new StringVal(this.parseString$1());
                }
                if (c == 't') {
                    this.fieldNameMode = true;
                    if (this.buf.charAt(this.cur + 1) == 'r' && this.buf.charAt(this.cur + 2) == 'u' && this.buf.charAt(this.cur + 3) == 'e' && this.isDelimiter$1(this.buf.charAt(this.cur + 4))) {
                        this.cur += 4;
                        return new BoolVal(true);
                    }
                    throw Predef$.MODULE$.error("expected boolean");
                }
                if (c == 'f') {
                    this.fieldNameMode = true;
                    if (this.buf.charAt(this.cur + 1) == 'a' && this.buf.charAt(this.cur + 2) == 'l' && this.buf.charAt(this.cur + 3) == 's' && this.buf.charAt(this.cur + 4) == 'e' && this.isDelimiter$1(this.buf.charAt(this.cur + 5))) {
                        this.cur += 5;
                        return new BoolVal(false);
                    }
                    throw Predef$.MODULE$.error("expected boolean");
                }
                if (c == 'n') {
                    this.fieldNameMode = true;
                    if (this.buf.charAt(this.cur + 1) == 'u' && this.buf.charAt(this.cur + 2) == 'l' && this.buf.charAt(this.cur + 3) == 'l' && this.isDelimiter$1(this.buf.charAt(this.cur + 4))) {
                        this.cur += 4;
                        return JsonParser$NullVal$.MODULE$;
                    }
                    throw Predef$.MODULE$.error("expected null");
                }
                if (c == ':') {
                    this.fieldNameMode = false;
                    ++this.cur;
                    continue;
                }
                if (c == '[') {
                    this.blocks.addFirst(this.ARRAY());
                    ++this.cur;
                    return JsonParser$OpenArr$.MODULE$;
                }
                if (c == ']') {
                    this.fieldNameMode = true;
                    this.blocks.poll();
                    ++this.cur;
                    return JsonParser$CloseArr$.MODULE$;
                }
                char c2 = c;
                if (this.gd11$1(c2)) {
                    this.fieldNameMode = true;
                    return (Token)this.parseValue$1();
                }
                char c3 = c;
                if (this.gd12$1(c3)) {
                    ++this.cur;
                    continue;
                }
                throw Predef$.MODULE$.error(new scala.StringBuilder().append((Object)"unknown token ").append((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
            }
            return JsonParser$End$.MODULE$;
        }

        public Nothing$ fail(String msg) {
            throw new ParseException(new scala.StringBuilder().append((Object)msg).append((Object)"\nNear: ").append((Object)this.buf.substring(Predef$.MODULE$.intWrapper(this.cur - 20).max(0), Predef$.MODULE$.intWrapper(this.cur + 20).min(this.buf.length() - 1))).toString(), null);
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }

        public abstract class BlockMode
        implements ScalaObject {
            public BlockMode() {
                if (Parser.this == null) {
                    throw new NullPointerException();
                }
            }

            public /* synthetic */ Parser net$liftweb$json$JsonParser$Parser$BlockMode$$$outer() {
                return Parser.this;
            }

            public int $tag() throws RemoteException {
                return ScalaObject.class.$tag((ScalaObject)this);
            }
        }
    }

    public static class IntVal
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final BigInt value;

        public IntVal(BigInt value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd3$1(BigInt x$1) {
            BigInt bigInt = x$1;
            BigInt bigInt2 = this.value();
            return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.value();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "IntVal";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof IntVal && this.gd3$1(((IntVal)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return -1040423063;
        }

        public BigInt value() {
            return this.value;
        }
    }

    public static class MField
    implements MValue,
    ScalaObject,
    Product,
    Serializable {
        private MValue value;
        private final String name;

        public MField(String name, MValue value) {
            this.name = name;
            this.value = value;
            Product.class.$init$((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final /* synthetic */ boolean gd6$1(MValue x$1, String x$2) {
            String string = x$2;
            String string2 = this.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            MValue mValue = x$1;
            MValue mValue2 = this.value();
            if (mValue == null) {
                if (mValue2 == null) return true;
                return false;
            } else {
                if (!mValue.equals(mValue2)) return false;
                return true;
            }
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.value();
                    break;
                }
                case 0: {
                    object = this.name();
                }
            }
            return object;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MField";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (!(x$1 instanceof Object)) return false;
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MField)) return false;
            MField mField = (MField)object;
            boolean bl = this.gd6$1(mField.value(), mField.name());
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return -963160252;
        }

        public JsonAST.JField toJValue() {
            return new JsonAST.JField(this.name(), this.value().toJValue());
        }

        public void value_$eq(MValue x$1) {
            this.value = x$1;
        }

        public MValue value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }
    }

    public static class MDouble
    implements MValue,
    ScalaObject,
    Product,
    Serializable {
        private final double value;

        public MDouble(double value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd9$1(double x$1) {
            return x$1 == this.value();
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return BoxesRunTime.boxToDouble((double)this.value());
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MDouble";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof MDouble && this.gd9$1(((MDouble)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 155553479;
        }

        public JsonAST.JDouble toJValue() {
            return new JsonAST.JDouble(this.value());
        }

        public double value() {
            return this.value;
        }
    }

    public static class MString
    implements MValue,
    ScalaObject,
    Product,
    Serializable {
        private final String value;

        public MString(String value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd7$1(String x$1) {
            String string = x$1;
            String string2 = this.value();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.value();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MString";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof MString && this.gd7$1(((MString)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 589525767;
        }

        public JsonAST.JString toJValue() {
            return new JsonAST.JString(this.value());
        }

        public String value() {
            return this.value;
        }
    }

    public static class BoolVal
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final boolean value;

        public BoolVal(boolean value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd5$1(boolean x$1) {
            return x$1 == this.value();
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return BoxesRunTime.boxToBoolean((boolean)this.value());
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BoolVal";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof BoolVal && this.gd5$1(((BoolVal)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 213721088;
        }

        public boolean value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MObject
    implements MValue,
    MBlock<MField>,
    ScalaObject,
    Product {
        private List elems;

        public MObject() {
            JsonParser$MBlock$class.$init$(this);
            Product.class.$init$((Product)this);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "MObject";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof MObject);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 458143285;
        }

        @Override
        public JsonAST.JObject toJValue() {
            return new JsonAST.JObject((List<JsonAST.JField>)this.elems().map((Function1)new MObject$$anonfun$toJValue$1(this)).reverse());
        }

        @Override
        public void $plus$eq(MValue x$1) {
            JsonParser$MBlock$class.$plus$eq(this, x$1);
        }

        @Override
        public void elems_$eq(List x$1) {
            this.elems = x$1;
        }

        @Override
        public List elems() {
            return this.elems;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValStack
    implements ScalaObject {
        private final LinkedList<MValue> stack;
        private final Parser parser;

        public ValStack(Parser parser) {
            this.parser = parser;
            this.stack = new LinkedList();
        }

        public Option<MValue> peekOption() {
            return this.stack.isEmpty() ? None$.MODULE$ : new Some((Object)this.stack.peek());
        }

        public <A extends MValue> A peek() {
            MValue mValue = this.stack.peek();
            if (mValue instanceof MValue) {
                return (A)mValue;
            }
            throw this.parser.fail(new scala.StringBuilder().append((Object)"unexpected ").append((Object)mValue).toString());
        }

        public void push(MValue v) {
            this.stack.addFirst(v);
        }

        public <A extends MValue> A pop() {
            MValue mValue = this.stack.poll();
            if (mValue instanceof MValue) {
                return (A)mValue;
            }
            throw this.parser.fail(new scala.StringBuilder().append((Object)"unexpected ").append((Object)mValue).toString());
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }

    public static class StringVal
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final String value;

        public StringVal(String value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd2$1(String x$1) {
            String string = x$1;
            String string2 = this.value();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.value();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StringVal";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof StringVal && this.gd2$1(((StringVal)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 1288646457;
        }

        public String value() {
            return this.value;
        }
    }

    public static class DoubleVal
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final double value;

        public DoubleVal(double value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd4$1(double x$1) {
            return x$1 == this.value();
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return BoxesRunTime.boxToDouble((double)this.value());
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DoubleVal";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof DoubleVal && this.gd4$1(((DoubleVal)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 671775609;
        }

        public double value() {
            return this.value;
        }
    }

    public static class FieldStart
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final String name;

        public FieldStart(String name) {
            this.name = name;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd1$1(String x$1) {
            String string = x$1;
            String string2 = this.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.name();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FieldStart";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof FieldStart && this.gd1$1(((FieldStart)object).name()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return -862849345;
        }

        public String name() {
            return this.name;
        }
    }

    public static class ParseException
    extends Exception
    implements ScalaObject {
        public ParseException(String message, Exception cause) {
            super(message, cause);
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }
}

