/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.decorate;

import java.util.ArrayList;
import java.util.List;
import net.logstash.logback.decorate.Decorator;

public abstract class FeatureDecorator<T, F extends Enum<F>>
implements Decorator<T> {
    private final Class<F> enumType;
    private final List<F> enables = new ArrayList<F>();
    private final List<F> disables = new ArrayList<F>();

    protected FeatureDecorator(Class<F> enumType) {
        this.enumType = enumType;
    }

    @Override
    public T decorate(T decoratable) {
        T decorated = decoratable;
        for (Enum feature : this.enables) {
            decorated = this.configure(decorated, feature, true);
        }
        for (Enum feature : this.disables) {
            decorated = this.configure(decorated, feature, false);
        }
        return decorated;
    }

    protected abstract T configure(T var1, F var2, boolean var3);

    public void addEnable(String feature) {
        this.enable(Enum.valueOf(this.enumType, feature));
    }

    public void enable(F feature) {
        this.enables.add(feature);
    }

    public void addDisable(String feature) {
        this.disable(Enum.valueOf(this.enumType, feature));
    }

    public void disable(F feature) {
        this.disables.add(feature);
    }
}

