/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.argument.StructuredArguments;
import net.logstash.logback.marker.LogstashMarker;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.util.NameTransformer;

public class ObjectFieldsAppendingMarker
extends LogstashMarker
implements StructuredArgument {
    public static final String MARKER_NAME = "LS_OBJECT_FIELDS";
    private final Object object;
    private static final Map<ValueSerializer<Object>, ValueSerializer<Object>> unwrappingSerializerCache = new ConcurrentHashMap<ValueSerializer<Object>, ValueSerializer<Object>>();

    public ObjectFieldsAppendingMarker(Object object) {
        super(MARKER_NAME);
        this.object = object;
    }

    @Override
    public void writeTo(JsonGenerator generator) {
        SerializationContext serializationContext;
        ValueSerializer valueSerializer;
        ValueSerializer unwrappingSerializer;
        ObjectWriteContext objectWriteContext;
        if (this.object != null && (objectWriteContext = generator.objectWriteContext()) instanceof SerializationContext && (unwrappingSerializer = unwrappingSerializerCache.computeIfAbsent((ValueSerializer<Object>)(valueSerializer = (serializationContext = (SerializationContext)objectWriteContext).findValueSerializer(this.object.getClass())), vs -> vs.unwrappingSerializer(NameTransformer.NOP))).isUnwrappingSerializer()) {
            unwrappingSerializer.serialize(this.object, generator, serializationContext);
        }
    }

    @Override
    public String toStringSelf() {
        return StructuredArguments.toString(this.object);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectFieldsAppendingMarker)) {
            return false;
        }
        ObjectFieldsAppendingMarker other = (ObjectFieldsAppendingMarker)obj;
        return Objects.equals(this.object, other.object);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }
}

