/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.errorprone;

import java.util.Collections;
import net.ltgt.gradle.errorprone.ErrorProneBasePlugin;
import net.ltgt.gradle.errorprone.ErrorProneToolChain;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.internal.toolchain.DefaultResolvedCompiler;
import org.gradle.platform.base.internal.toolchain.DefaultResolvedTool;
import org.gradle.platform.base.internal.toolchain.ResolvedTool;
import org.gradle.platform.base.internal.toolchain.ToolResolver;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;

public class ErrorPronePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.apply(Collections.singletonMap("plugin", ErrorProneBasePlugin.class));
        final ErrorProneToolChain toolChain = ErrorProneToolChain.create(project);
        Action<JavaCompile> action = new Action<JavaCompile>(){

            public void execute(JavaCompile task) {
                final ToolResolver oldToolResolver = task.getToolResolver();
                task.setToolResolver(new ToolResolver(){

                    public <P extends Platform> ToolSearchResult checkToolAvailability(P requirement) {
                        if (requirement instanceof JavaPlatform) {
                            return toolChain.select((JavaPlatform)requirement);
                        }
                        return oldToolResolver.checkToolAvailability(requirement);
                    }

                    public <T, P extends Platform> ResolvedTool<T> resolve(Class<T> toolType, P requirement) {
                        if (requirement instanceof JavaPlatform) {
                            return new DefaultResolvedTool(toolChain.select((JavaPlatform)requirement), toolType);
                        }
                        return oldToolResolver.resolve(toolType, requirement);
                    }

                    public <C extends CompileSpec, P extends Platform> ResolvedTool<Compiler<C>> resolveCompiler(Class<C> specType, P requirement) {
                        if (requirement instanceof JavaPlatform) {
                            return new DefaultResolvedCompiler(toolChain.select((JavaPlatform)requirement), specType);
                        }
                        return oldToolResolver.resolveCompiler(specType, requirement);
                    }
                });
            }
        };
        TaskCollection javaCompileTasks = project.getTasks().withType(JavaCompile.class);
        javaCompileTasks.all((Action)action);
        javaCompileTasks.whenTaskAdded((Action)action);
    }
}

