/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.errorprone;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.language.base.internal.compile.Compiler;

public class ErrorProneCompiler
implements Compiler<JavaCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(ErrorProneCompiler.class);
    private final Configuration errorprone;

    public ErrorProneCompiler(Configuration errorprone) {
        this.errorprone = errorprone;
    }

    public WorkResult execute(JavaCompileSpec spec) {
        LOGGER.info("Compiling with error-prone compiler");
        List args = new JavaCompilerArgumentsBuilder(spec).includeSourceFiles(true).build();
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (File f : this.errorprone) {
                urls.add(f.toURI().toURL());
            }
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue.getMessage(), mue);
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        int exitCode = 0;
        try (SelfFirstClassLoader cl = new SelfFirstClassLoader(urls.toArray(new URL[urls.size()]));){
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> builderClass = ((ClassLoader)cl).loadClass("com.google.errorprone.ErrorProneCompiler$Builder");
            Object compilerBuilder = builderClass.newInstance();
            Object compiler = builderClass.getMethod("build", new Class[0]).invoke(compilerBuilder, new Object[0]);
            Object result = compiler.getClass().getMethod("compile", String[].class).invoke(compiler, new Object[]{args.toArray(new String[args.size()])});
            exitCode = result instanceof Integer ? ((Integer)result).intValue() : result.getClass().getField("exitCode").getInt(result);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        if (exitCode != 0) {
            throw new CompilationFailedException(exitCode);
        }
        return new SimpleWorkResult(true);
    }

    private static class SelfFirstClassLoader
    extends URLClassLoader {
        private static ClassLoader BOOTSTRAP_ONLY_CLASSLOADER;

        public SelfFirstClassLoader(URL[] urls) {
            super(urls, (ClassLoader)null);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> cls = this.findLoadedClass(name);
                if (cls == null) {
                    try {
                        cls = this.findClass(name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                    if (cls == null) {
                        cls = BOOTSTRAP_ONLY_CLASSLOADER.loadClass(name);
                    }
                }
                if (resolve) {
                    this.resolveClass(cls);
                }
                return cls;
            }
        }

        @Override
        public URL getResource(String name) {
            URL resource = this.findResource(name);
            if (resource == null) {
                BOOTSTRAP_ONLY_CLASSLOADER.getResource(name);
            }
            return resource;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> selfResources = this.findResources(name);
            Enumeration<URL> bootstrapResources = BOOTSTRAP_ONLY_CLASSLOADER.getResources(name);
            if (!selfResources.hasMoreElements()) {
                return bootstrapResources;
            }
            if (!bootstrapResources.hasMoreElements()) {
                return selfResources;
            }
            ArrayList<URL> resources = Collections.list(selfResources);
            resources.addAll(Collections.list(bootstrapResources));
            return Collections.enumeration(resources);
        }

        static {
            try {
                BOOTSTRAP_ONLY_CLASSLOADER = new URLClassLoader(new URL[]{Jvm.current().getToolsJar().toURI().toURL()}, null);
            }
            catch (MalformedURLException mue) {
                throw new RuntimeException(mue.getMessage(), mue);
            }
            ClassLoader.registerAsParallelCapable();
        }
    }
}

