/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.ltgt.gwt.maven.AbstractSourcesAsResourcesMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractImportSourcesMojo
extends AbstractSourcesAsResourcesMojo {
    @Component(hint="jar")
    private UnArchiver unArchiver;

    public void execute() throws MojoExecutionException {
        for (String sourceRoot : this.getSourceRoots()) {
            this.addResource(sourceRoot);
        }
        if (!this.getOutputDirectory().exists() && !this.getOutputDirectory().mkdirs()) {
            throw new MojoExecutionException("Cannot create output directory: " + this.getOutputDirectory().getAbsolutePath());
        }
        this.unArchiver.setDestDirectory(this.getOutputDirectory());
        this.addResource(this.getOutputDirectory().getPath());
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            if (!this.includeArtifact(artifact)) continue;
            if (!"java-source".equals(artifact.getArtifactHandler().getPackaging())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping non-java-source dependency: " + artifact.getId()));
                continue;
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Importing " + artifact.getId()));
            }
            if (artifact.getFile().isDirectory()) {
                this.getLog().warn((CharSequence)(artifact.getId() + " has not been packaged yet, trying to infer sources from reactor."));
                this.importFromProjectReferences(ArtifactUtils.key((Artifact)artifact));
                continue;
            }
            this.unArchiver.setSourceFile(artifact.getFile());
            this.unArchiver.extract();
        }
    }

    private void importFromProjectReferences(String id) throws MojoExecutionException {
        try {
            MavenProject reference = (MavenProject)this.project.getProjectReferences().get(id);
            for (String sourceRoot : reference.getCompileSourceRoots()) {
                File sourceDirectory = new File(sourceRoot);
                if (!sourceDirectory.isAbsolute()) {
                    sourceDirectory = new File(reference.getBasedir(), sourceRoot);
                }
                if (sourceDirectory.exists()) {
                    this.getLog().info((CharSequence)("copying " + sourceDirectory));
                    FileUtils.copyDirectoryStructureIfModified((File)sourceDirectory, (File)this.getOutputDirectory());
                    continue;
                }
                this.getLog().info((CharSequence)("skip non existing imported source directory " + sourceDirectory));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void addResource(String resourceDirectory) {
        if (this.checkResource(resourceDirectory)) {
            Resource resource = this.createResource(resourceDirectory);
            this.addResource(resource);
        }
    }

    @Override
    protected abstract List<Resource> getProjectResources();

    @Override
    protected abstract void addResource(Resource var1);

    protected abstract Iterable<String> getSourceRoots();

    protected abstract File getOutputDirectory();

    protected abstract boolean includeArtifact(Artifact var1);
}

