/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.ltgt.gwt.maven.GwtOptions;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.util.DefaultScanResult;
import org.apache.maven.surefire.util.NestedCheckedException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class TestMojo
extends AbstractSurefireMojo
implements SurefireReportParameters,
GwtOptions {
    @Parameter(property="gwt.port")
    private int port;
    @Parameter(property="gwt.codeServerPort")
    private int codeServerPort;
    @Parameter(defaultValue="${project.build.directory}/gwt-tests/deploy")
    private File deploy;
    @Parameter
    private File extra;
    @Parameter(defaultValue="${project.build.directory}/gwt/work")
    private File workDir;
    @Parameter(property="gwt.style", defaultValue="OBFUSCATED")
    private GwtOptions.Style style;
    @Parameter(property="gwt.test.devMode", defaultValue="true")
    private boolean devMode;
    @Parameter(property="gwt.draftCompile", defaultValue="false")
    private boolean draftCompile;
    @Parameter(property="gwt.localWorkers")
    private int localWorkers;
    @Parameter(property="gwt.logLevel")
    private GwtOptions.LogLevel logLevel;
    @Parameter(property="gwt.optimize", defaultValue="9")
    private int optimize;
    @Parameter(property="maven.compiler.source")
    private String sourceLevel;
    @Parameter(defaultValue="${project.build.directory}/gwt-tests/www")
    private File outDir;
    @Parameter
    private List<String> compilerArgs;
    @Parameter
    private List<String> testArgs;
    @Parameter(defaultValue="false")
    private boolean useCompilerArgsForTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;
    @Parameter(property="test")
    private String test;
    @Parameter(property="surefire.printSummary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="surefire.reportFormat", defaultValue="brief")
    private String reportFormat;
    @Parameter(property="surefire.useFile", defaultValue="true")
    private boolean useFile;
    @Parameter(property="surefire.failIfNoSpecifiedTests")
    private Boolean failIfNoSpecifiedTests;
    @Parameter(property="maven.surefire.debug")
    private String debugForkedProcess;
    @Parameter(property="surefire.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter
    private List<String> includes;
    @Parameter(property="failsafe.parallel.timeout")
    private int parallelTestsTimeoutInSeconds;
    @Parameter(property="failsafe.parallel.forcedTimeout")
    private int parallelTestsTimeoutForcedInSeconds;

    public Map<String, String> getSystemPropertyVariables() {
        HashMap<String, String> props = super.getSystemPropertyVariables();
        if (props == null) {
            props = new HashMap<String, String>(2);
        }
        if (!props.containsKey("gwt.args")) {
            StringBuilder sb = new StringBuilder();
            if (this.port > 0) {
                sb.append(" -port ").append(this.port);
            }
            if (this.codeServerPort > 0) {
                sb.append(" -codeServerPort ").append(this.codeServerPort);
            }
            for (String arg : GwtOptions.CommandlineBuilder.buildArgs(this.getLog(), this)) {
                sb.append(" ").append(this.quote(arg));
            }
            sb.append(this.devMode ? " -devMode" : " -nodevMode");
            sb.append(this.effectiveIsEnableAssertions() ? " -checkAssertions" : " -nocheckAssertions");
            if (this.useCompilerArgsForTests && this.compilerArgs != null) {
                for (String arg : this.compilerArgs) {
                    sb.append(" ").append(this.quote(arg));
                }
            }
            if (this.testArgs != null) {
                for (String arg : this.testArgs) {
                    sb.append(" ").append(this.quote(arg));
                }
            }
            props.put("gwt.args", sb.toString());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using gwt.args: " + (String)props.get("gwt.args")));
        }
        return props;
    }

    private Object quote(String value) {
        if (value.matches(".*[\"\\s].*")) {
            return "\"" + value.replace("\"", "\\\"") + "\"";
        }
        return value;
    }

    public void setSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
        if (systemPropertyVariables.containsKey("gwt.args")) {
            this.getLog().warn((CharSequence)"systemPropertyVariables contains a gwt.args value, this will override all individual options");
        }
        super.setSystemPropertyVariables(systemPropertyVariables);
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
        checksum.add(this.port);
        checksum.add(this.codeServerPort);
        checksum.add(this.deploy);
        checksum.add(this.extra);
        checksum.add(this.workDir);
        checksum.add(this.style.name());
        checksum.add(this.draftCompile);
        checksum.add(this.localWorkers);
        checksum.add(this.devMode);
        checksum.add(this.sourceLevel);
        checksum.add(this.compilerArgs);
        checksum.add(this.testArgs);
        checksum.add(this.useCompilerArgsForTests);
    }

    protected void handleSummary(RunResult summary, NestedCheckedException firstForkException) throws MojoExecutionException, MojoFailureException {
        this.assertNoException(firstForkException);
        SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)summary, (Log)this.getLog());
    }

    private void assertNoException(NestedCheckedException firstForkException) throws MojoFailureException {
        if (firstForkException != null) {
            throw new MojoFailureException(firstForkException.getMessage(), (Throwable)firstForkException);
        }
    }

    protected void executeAfterPreconditionsChecked(DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        if (this.getEffectiveForkCount() <= 0) {
            this.getLog().warn((CharSequence)"ForkCount=0 is known not to work for GWT tests");
        }
        super.executeAfterPreconditionsChecked(scanResult);
    }

    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipExec();
    }

    protected String getPluginName() {
        return "GWT tests";
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/*Suite.java", "**/*SuiteNoBrowser.java"};
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipExec() {
        return this.skipExec;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getTest() {
        if (StringUtils.isBlank((String)this.test)) {
            return null;
        }
        String[] testArray = StringUtils.split((String)this.test, (String)",");
        StringBuilder tests = new StringBuilder();
        for (String aTestArray : testArray) {
            String singleTest = aTestArray;
            int index = singleTest.indexOf(35);
            if (index >= 0) {
                singleTest = singleTest.substring(0, index);
            }
            tests.append(singleTest);
            tests.append(",");
        }
        return tests.toString();
    }

    public String getTestMethod() {
        if (StringUtils.isBlank((String)this.test)) {
            return null;
        }
        int index = this.test.indexOf(35);
        int index2 = this.test.indexOf(",");
        if (index >= 0) {
            if (index2 < 0) {
                String testStrAfterFirstSharp = this.test.substring(index + 1, this.test.length());
                if (!testStrAfterFirstSharp.contains("+")) {
                    return testStrAfterFirstSharp;
                }
                return this.test;
            }
            return this.test;
        }
        return null;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public boolean isUseSystemClassLoader() {
        return true;
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        throw new UnsupportedOperationException("useSystemClassLoader is read-only");
    }

    public boolean isUseManifestOnlyJar() {
        return false;
    }

    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        throw new UnsupportedOperationException("useManifestOnlyJar is read-only");
    }

    public Boolean getFailIfNoSpecifiedTests() {
        return this.failIfNoSpecifiedTests;
    }

    public void setFailIfNoSpecifiedTests(Boolean failIfNoSpecifiedTests) {
        this.failIfNoSpecifiedTests = failIfNoSpecifiedTests;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public int getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    public void setParallelTestsTimeoutInSeconds(int parallelTestsTimeoutInSeconds) {
        this.parallelTestsTimeoutInSeconds = parallelTestsTimeoutInSeconds;
    }

    public int getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    public void setParallelTestsTimeoutForcedInSeconds(int parallelTestsTimeoutForcedInSeconds) {
        this.parallelTestsTimeoutForcedInSeconds = parallelTestsTimeoutForcedInSeconds;
    }

    @Override
    public GwtOptions.LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public GwtOptions.Style getStyle() {
        return this.style;
    }

    @Override
    public int getOptimize() {
        return this.optimize;
    }

    @Override
    public File getWarDir() {
        return this.outDir;
    }

    @Override
    public File getWorkDir() {
        return this.workDir;
    }

    @Override
    public File getDeployDir() {
        return this.deploy;
    }

    @Override
    @Nullable
    public File getExtraDir() {
        return this.extra;
    }

    @Override
    public boolean isDraftCompile() {
        return this.draftCompile;
    }

    @Override
    public int getLocalWorkers() {
        return this.localWorkers;
    }

    @Override
    public String getSourceLevel() {
        return this.sourceLevel;
    }
}

