/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ltgt.gwt.maven.GwtOptions;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractDevModeMojo
extends AbstractMojo {
    @Parameter(property="gwt.logLevel")
    protected GwtOptions.LogLevel logLevel;
    @Parameter(property="gwt.modules")
    protected String modules;
    @Parameter(property="gwt.projects")
    protected String projects;
    @Parameter(defaultValue="runtime")
    protected String classpathScope;
    @Parameter(property="maven.compiler.source")
    protected String sourceLevel;
    @Parameter
    protected List<String> jvmArgs;
    @Parameter
    protected Map<String, String> systemProperties;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    PluginDescriptor pluginDescriptor;

    public void execute() throws MojoExecutionException, MojoFailureException {
        int result;
        ArrayList<MavenProject> projectList = new ArrayList<MavenProject>();
        if (StringUtils.isBlank((String)this.projects)) {
            if (this.reactorProjects.size() == 1) {
                projectList.add(this.reactorProjects.get(0));
            } else {
                for (MavenProject p : this.reactorProjects) {
                    if (!p.getPackaging().equals("gwt-app")) continue;
                    projectList.add(p);
                }
            }
        } else {
            HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
            LinkedHashSet<String> ambiguousProjectIds = new LinkedHashSet<String>();
            for (MavenProject p : this.reactorProjects) {
                String key = p.getArtifactId();
                if (projectMap.put(key, p) != null) {
                    projectMap.remove(key);
                    ambiguousProjectIds.add(key);
                }
                if (projectMap.put(key = ":" + key, p) != null) {
                    projectMap.remove(key);
                    ambiguousProjectIds.add(key);
                }
                if (projectMap.put(key = p.getGroupId() + key, p) == null) continue;
                projectMap.remove(key);
                ambiguousProjectIds.add(key);
            }
            for (String key : StringUtils.split((String)this.projects, (String)",")) {
                MavenProject p = (MavenProject)projectMap.get(key);
                if (p == null) {
                    if (ambiguousProjectIds.contains(key)) {
                        throw new MojoExecutionException("Ambiguous project identifier, there are several matching projects in the reactor: " + key);
                    }
                    throw new MojoExecutionException("Could not find the selected project in the reactor: " + key);
                }
                projectList.add(p);
            }
        }
        if (projectList.isEmpty()) {
            throw new MojoExecutionException("No project found");
        }
        ArrayList<String> moduleList = new ArrayList<String>();
        if (StringUtils.isBlank((String)this.modules)) {
            ArrayList<String> nonGwtProjects = new ArrayList<String>();
            for (MavenProject p : projectList) {
                Xpp3Dom configuration = p.getGoalConfiguration(this.pluginDescriptor.getGroupId(), this.pluginDescriptor.getArtifactId(), null, null);
                if (configuration == null) {
                    nonGwtProjects.add(ArtifactUtils.versionlessKey((String)p.getGroupId(), (String)p.getArtifactId()));
                    continue;
                }
                moduleList.add(configuration.getChild("moduleName").getValue());
            }
            if (!nonGwtProjects.isEmpty()) {
                this.getLog().warn((CharSequence)("Found projects without the gwt-maven-plugin's moduleName when discovering GWT modules; they've been ignored: " + StringUtils.join(nonGwtProjects.iterator(), (String)", ")));
            }
        } else {
            moduleList.addAll(Arrays.asList(StringUtils.split((String)this.modules, (String)",")));
        }
        if (moduleList.isEmpty()) {
            throw new MojoExecutionException("No module found");
        }
        LinkedHashSet<String> sources = new LinkedHashSet<String>();
        for (MavenProject p : projectList) {
            this.addSources(p, sources);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.jvmArgs != null) {
            args.addAll(this.jvmArgs);
        }
        if (this.systemProperties != null) {
            for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                args.add("-D" + entry.getKey() + "=" + entry.getValue());
            }
        }
        args.add(this.getMainClass());
        args.add("-logLevel");
        args.add((this.logLevel == null ? GwtOptions.LogLevel.getLogLevel(this.getLog()) : this.logLevel).name());
        args.add("-workDir");
        args.add(this.getWorkDir().getAbsolutePath());
        if (this.sourceLevel != null) {
            args.add("-sourceLevel");
            args.add(this.sourceLevel);
        }
        args.addAll(this.getSpecificArguments(sources));
        args.addAll(moduleList);
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        if (this.prependSourcesToClasspath()) {
            cp.addAll(sources);
        }
        for (MavenProject p : projectList) {
            ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter(this.classpathScope);
            cp.add(p.getBuild().getOutputDirectory());
            for (Artifact artifact : p.getArtifacts()) {
                if (!artifact.getArtifactHandler().isAddedToClasspath() || !artifactFilter.include(artifact)) continue;
                cp.add(artifact.getFile().getPath());
            }
        }
        try {
            FileUtils.forceMkdir((File)new File(this.project.getBuild().getDirectory()));
            FileUtils.forceMkdir((File)this.getWorkDir());
            this.forceMkdirs();
        }
        catch (IOException ioe) {
            throw new MojoFailureException(ioe.getMessage(), (Throwable)ioe);
        }
        Commandline commandline = new Commandline();
        commandline.setWorkingDirectory(this.project.getBuild().getDirectory());
        commandline.setExecutable(Paths.get(System.getProperty("java.home"), "bin", "java").toString());
        commandline.addEnvironment("CLASSPATH", StringUtils.join(cp.iterator(), (String)File.pathSeparator));
        commandline.addArguments(args.toArray(new String[args.size()]));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Arguments: " + StringUtils.join((Object[])commandline.getArguments(), (String)" ")));
            this.getLog().debug((CharSequence)("Classpath: " + StringUtils.join(cp.iterator(), (String)File.pathSeparator)));
        }
        try {
            result = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String s) {
                    AbstractDevModeMojo.this.getLog().info((CharSequence)s);
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String s) {
                    AbstractDevModeMojo.this.getLog().warn((CharSequence)s);
                }
            });
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (result != 0) {
            throw new MojoExecutionException("GWT exited with status " + result);
        }
    }

    protected abstract String getMainClass();

    protected abstract File getWorkDir();

    protected abstract Collection<String> getSpecificArguments(Set<String> var1);

    protected boolean prependSourcesToClasspath() {
        return false;
    }

    protected abstract void forceMkdirs() throws IOException;

    private void addSources(MavenProject p, LinkedHashSet<String> sources) {
        this.getLog().debug((CharSequence)("Adding sources for " + p.getId()));
        if (p.getExecutionProject() != null) {
            p = p.getExecutionProject();
        }
        sources.addAll(p.getCompileSourceRoots());
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter(this.classpathScope);
        for (Artifact artifact : p.getDependencyArtifacts()) {
            if (!artifact.getArtifactHandler().isAddedToClasspath() || !artifactFilter.include(artifact)) continue;
            if (!"gwt-lib".equals(artifact.getArtifactHandler().getPackaging()) && !"sources".equals(artifact.getClassifier())) {
                this.getLog().debug((CharSequence)("Ignoring " + artifact.getId() + "; neither a gwt-lib or jar:sources."));
                continue;
            }
            String key = ArtifactUtils.key((Artifact)artifact);
            MavenProject reference = (MavenProject)p.getProjectReferences().get(key);
            if (reference == null) {
                this.getLog().debug((CharSequence)("Ignoring " + artifact.getId() + "; no corresponding project reference."));
                continue;
            }
            this.addSources(reference, sources);
        }
    }
}

