/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.ltgt.gwt.maven.AbstractDevModeMojo;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.io.FileUtils;

@Mojo(name="codeserver", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDirectInvocation=true, threadSafe=true, aggregator=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class CodeServerMojo
extends AbstractDevModeMojo {
    @Parameter(defaultValue="${project.build.directory}/gwt/codeserver")
    private File codeserverWorkDir;
    @Parameter(property="gwt.failOnError", defaultValue="false")
    protected boolean failOnError;
    @Parameter(property="launcherDir")
    private File launcherDir;
    @Parameter
    private List<String> codeserverArgs;

    @Override
    protected String getMainClass() {
        return "com.google.gwt.dev.codeserver.CodeServer";
    }

    @Override
    protected File getWorkDir() {
        return this.codeserverWorkDir;
    }

    @Override
    protected Collection<String> getSpecificArguments(Set<String> sources) {
        ArrayList<String> args = new ArrayList<String>(4 + (this.codeserverArgs == null ? 0 : this.codeserverArgs.size()) + sources.size() * 2);
        if (this.failOnError) {
            args.add("-failOnError");
        }
        if (this.launcherDir != null) {
            args.add("-launcherDir");
            args.add(this.launcherDir.getAbsolutePath());
        }
        if (this.codeserverArgs != null) {
            args.addAll(this.codeserverArgs);
        }
        args.add("-allowMissingSrc");
        for (String src : sources) {
            args.add("-src");
            args.add(src);
        }
        return args;
    }

    @Override
    protected void forceMkdirs() throws IOException {
        if (this.launcherDir != null) {
            FileUtils.forceMkdir((File)this.launcherDir);
        }
    }
}

