/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-module", threadSafe=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateModuleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter
    private String moduleName;
    @Parameter
    private String moduleShortName;
    @Parameter(defaultValue="${project.basedir}/src/main/module.gwt.xml")
    private File moduleTemplate;
    @Parameter(defaultValue="false")
    private boolean skipModule;
    @Parameter(defaultValue="${project.dependencyArtifacts}", required=true, readonly=true)
    private Set<Artifact> dependencyArtifacts;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    private final ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("compile+runtime");

    public void execute() throws MojoExecutionException, MojoFailureException {
        Xpp3Dom template;
        boolean uptodate;
        if (this.skipModule) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.moduleName)) {
            throw new MojoExecutionException("Missing moduleName");
        }
        File outputFile = new File(this.outputDirectory, this.moduleName.replace('.', '/') + ".gwt.xml");
        if (this.moduleTemplate.isFile()) {
            uptodate = this.buildContext.isUptodate(outputFile, this.moduleTemplate);
            try {
                template = Xpp3DomBuilder.build((Reader)Files.newReader((File)this.moduleTemplate, (Charset)Charsets.UTF_8));
            }
            catch (IOException | XmlPullParserException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else {
            uptodate = true;
            template = new Xpp3Dom("module");
        }
        if (uptodate) {
            uptodate = this.buildContext.isUptodate(outputFile, this.project.getFile());
        }
        if (uptodate) {
            // empty if block
        }
        outputFile.getParentFile().mkdirs();
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)writer);
            xmlWriter.startElement("module");
            String oldRenameTo = template.getAttribute("rename-to");
            if (!StringUtils.isBlank((CharSequence)this.moduleShortName)) {
                if (oldRenameTo != null) {
                    this.getLog().info((CharSequence)("Overriding module short name " + oldRenameTo + " with " + this.moduleShortName));
                }
                xmlWriter.addAttribute("rename-to", this.moduleShortName);
            } else if (oldRenameTo != null) {
                xmlWriter.addAttribute("rename-to", oldRenameTo);
            }
            for (String attrName : template.getAttributeNames()) {
                if ("rename-to".equals(attrName)) continue;
                xmlWriter.addAttribute(attrName, template.getAttribute(attrName));
            }
            boolean hasInherits = this.generateInheritsFromDependencies((XMLWriter)xmlWriter);
            boolean hasSource = false;
            for (Xpp3Dom child : template.getChildren()) {
                if ("inherits".equals(child.getName())) {
                    hasInherits = true;
                } else if ("source".equals(child.getName()) || "super-source".equals(child.getName())) {
                    hasSource = true;
                }
                Xpp3DomWriter.write((XMLWriter)xmlWriter, (Xpp3Dom)child);
            }
            if (!hasInherits) {
                xmlWriter.startElement("inherits");
                xmlWriter.addAttribute("name", "com.google.gwt.core.Core");
                xmlWriter.endElement();
            }
            if (!hasSource) {
                xmlWriter.startElement("source");
                xmlWriter.addAttribute("path", "client");
                xmlWriter.endElement();
                xmlWriter.startElement("source");
                xmlWriter.addAttribute("path", "shared");
                xmlWriter.endElement();
                xmlWriter.startElement("super-source");
                xmlWriter.addAttribute("path", "super");
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        try {
            if (outputFile.isFile() && ((Object)writer).toString().equals(FileUtils.fileRead((File)outputFile, (String)"UTF-8"))) {
                this.getLog().info((CharSequence)(outputFile.getAbsolutePath() + " up to date - skipping"));
                return;
            }
            FileUtils.fileWrite((File)outputFile, (String)"UTF-8", (String)((Object)writer).toString());
            this.buildContext.refresh(outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private boolean generateInheritsFromDependencies(XMLWriter xmlWriter) throws IOException, MojoExecutionException {
        ClassRealm realm;
        ClassWorld world = new ClassWorld();
        try {
            realm = world.newRealm("gwt", null);
            for (Artifact artifact : this.dependencyArtifacts) {
                if (!this.artifactFilter.include(artifact) || !artifact.getArtifactHandler().isAddedToClasspath()) continue;
                realm.addURL(artifact.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException | DuplicateRealmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        boolean hasInherits = false;
        Enumeration resources = realm.getResources("META-INF/gwt/mainModule");
        while (resources.hasMoreElements()) {
            final URL resource = (URL)resources.nextElement();
            String moduleName = (String)Resources.readLines((URL)resource, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<String>(){
                private String module;

                public boolean processLine(String line) throws IOException {
                    if ((line = StringUtils.substringBefore((String)line, (String)"#").trim()).isEmpty()) {
                        return true;
                    }
                    if (this.module != null) {
                        GenerateModuleMojo.this.getLog().warn((CharSequence)("Configuration file contains more than one module name, picking first: " + resource));
                        return false;
                    }
                    this.module = line;
                    return true;
                }

                public String getResult() {
                    return this.module;
                }
            });
            if (moduleName == null) continue;
            hasInherits = true;
            xmlWriter.startElement("inherits");
            xmlWriter.addAttribute("name", moduleName);
            xmlWriter.endElement();
        }
        return hasInherits;
    }
}

