/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

public interface GwtOptions {
    public LogLevel getLogLevel();

    public Style getStyle();

    public int getOptimize();

    public File getWarDir();

    public File getWorkDir();

    public File getDeployDir();

    @Nullable
    public File getExtraDir();

    public boolean isDraftCompile();

    public int getLocalWorkers();

    @Nullable
    public String getSourceLevel();

    public static class CommandlineBuilder {
        public static List<String> buildArgs(Log log, GwtOptions options) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-logLevel");
            args.add(CommandlineBuilder.getLogLevel(log, options.getLogLevel()));
            args.add("-war");
            args.add(options.getWarDir().getAbsolutePath());
            args.add("-workDir");
            args.add(options.getWorkDir().getAbsolutePath());
            args.add("-deploy");
            args.add(options.getDeployDir().getAbsolutePath());
            if (options.getExtraDir() != null) {
                args.add("-extra");
                args.add(options.getExtraDir().getAbsolutePath());
            }
            args.add("-style");
            args.add(options.getStyle().name());
            args.add("-localWorkers");
            args.add(CommandlineBuilder.getLocalWorkers(log, options.getLocalWorkers()));
            if (options.isDraftCompile()) {
                args.add("-draftCompile");
            } else {
                args.add("-optimize");
                args.add(CommandlineBuilder.getOptimize(options.getOptimize()));
            }
            if (options.getSourceLevel() != null) {
                args.add("-sourceLevel");
                args.add(options.getSourceLevel());
            }
            return args;
        }

        private static String getLogLevel(Log log, LogLevel logLevel) {
            return (logLevel == null ? LogLevel.getLogLevel(log) : logLevel).name();
        }

        private static String getLocalWorkers(Log log, int localWorkers) {
            if (localWorkers < 1) {
                localWorkers = Runtime.getRuntime().availableProcessors();
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Using " + localWorkers + " local workers"));
                }
            }
            return String.valueOf(localWorkers);
        }

        private static String getOptimize(int optimize) {
            if (optimize < 0) {
                optimize = 0;
            } else if (optimize > 9) {
                optimize = 9;
            }
            return String.valueOf(optimize);
        }
    }

    public static enum Style {
        DETAILED,
        OBFUSCATED,
        PRETTY;

    }

    public static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        TRACE,
        DEBUG,
        SPAM;


        public static LogLevel getLogLevel(Log log) {
            LogLevel logLevel = log.isDebugEnabled() ? DEBUG : (log.isInfoEnabled() ? INFO : (log.isWarnEnabled() ? WARN : ERROR));
            return logLevel;
        }
    }
}

