/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

class CommandLine {
    CommandLine() {
    }

    static void execute(final Log log, MavenProject project, Iterable<String> classpath, List<String> arguments) throws MojoExecutionException {
        int result;
        String cp = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
        String[] args = arguments.toArray(new String[arguments.size()]);
        Commandline commandline = new Commandline();
        commandline.setWorkingDirectory(project.getBuild().getDirectory());
        commandline.setExecutable(Paths.get(System.getProperty("java.home"), "bin", "java").toString());
        commandline.addEnvironment("CLASSPATH", cp);
        commandline.addArguments(args);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Classpath: " + cp));
            log.debug((CharSequence)("Arguments: " + CommandLineUtils.toString((String[])args)));
        }
        try {
            result = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String s) {
                    log.info((CharSequence)s);
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String s) {
                    log.warn((CharSequence)s);
                }
            });
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (result != 0) {
            throw new MojoExecutionException("GWT exited with status " + result);
        }
    }
}

