/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.ltgt.gwt.maven.GwtOptions;
import net.ltgt.gwt.maven.SourcesAsResourcesHelper;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.suite.RunResult;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class TestMojo
extends AbstractSurefireMojo
implements SurefireReportParameters,
GwtOptions {
    @Parameter(property="gwt.port")
    private int port;
    @Parameter(property="gwt.codeServerPort")
    private int codeServerPort;
    @Parameter(defaultValue="${project.build.directory}/gwt-tests/deploy", required=true)
    private File deploy;
    @Parameter
    private File extra;
    @Parameter(defaultValue="${project.build.directory}/gwt/work", required=true)
    private File workDir;
    @Parameter(property="gwt.style")
    private String style;
    @Parameter(property="gwt.draftCompile", defaultValue="false")
    private boolean draftCompile;
    @Parameter(property="gwt.localWorkers")
    private String localWorkers;
    @Parameter(property="gwt.logLevel")
    private String logLevel;
    @Parameter(property="gwt.optimize")
    private Integer optimize;
    @Parameter(property="maven.compiler.source")
    private String sourceLevel;
    @Parameter(defaultValue="${project.build.directory}/gwt-tests/www", required=true)
    private File outDir;
    @Parameter
    private List<String> compilerArgs;
    @Parameter
    private List<String> testArgs;
    @Parameter(defaultValue="false")
    private boolean useCompilerArgsForTests;
    private String[] computedAdditionalClasspathElements;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;
    @Parameter(property="test")
    private String test;
    @Parameter(property="surefire.printSummary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="surefire.reportFormat", defaultValue="brief")
    private String reportFormat;
    @Parameter(property="surefire.useFile", defaultValue="true")
    private boolean useFile;
    @Parameter(property="surefire.failIfNoSpecifiedTests")
    private Boolean failIfNoSpecifiedTests;
    @Parameter(property="maven.surefire.debug")
    private String debugForkedProcess;
    @Parameter(property="surefire.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(property="surefire.exitTimeout", defaultValue="30")
    private int forkedProcessExitTimeoutInSeconds;
    @Parameter(property="surefire.parallel.timeout")
    private double parallelTestsTimeoutInSeconds;
    @Parameter(property="surefire.parallel.forcedTimeout")
    private double parallelTestsTimeoutForcedInSeconds;
    @Parameter
    private List<String> includes;
    @Parameter(property="surefire.rerunFailingTestsCount", defaultValue="0")
    private int rerunFailingTestsCount;
    @Parameter(property="surefire.suiteXmlFiles")
    private File[] suiteXmlFiles;
    @Parameter(property="surefire.runOrder", defaultValue="filesystem")
    private String runOrder;
    @Parameter(property="surefire.includesFile")
    private File includesFile;
    @Parameter(property="surefire.excludesFile")
    private File excludesFile;
    @Parameter(property="surefire.skipAfterFailureCount", defaultValue="0")
    private int skipAfterFailureCount;
    @Parameter(property="surefire.shutdown", defaultValue="testset")
    private String shutdown;

    public Map<String, String> getSystemPropertyVariables() {
        HashMap<String, String> props = super.getSystemPropertyVariables();
        if (props == null) {
            props = new HashMap<String, String>(2);
        }
        if (!props.containsKey("gwt.args")) {
            StringBuilder sb = new StringBuilder();
            if (this.port > 0) {
                sb.append(" -port ").append(this.port);
            }
            if (this.codeServerPort > 0) {
                sb.append(" -codeServerPort ").append(this.codeServerPort);
            }
            for (String arg : GwtOptions.CommandlineBuilder.buildArgs(this.getLog(), this)) {
                sb.append(" ").append(this.quote(arg));
            }
            sb.append(this.effectiveIsEnableAssertions() ? " -checkAssertions" : " -nocheckAssertions");
            if (this.useCompilerArgsForTests && this.compilerArgs != null) {
                for (String arg : this.compilerArgs) {
                    sb.append(" ").append(this.quote(arg));
                }
            }
            if (this.testArgs != null) {
                for (String arg : this.testArgs) {
                    sb.append(" ").append(this.quote(arg));
                }
            }
            props.put("gwt.args", sb.toString());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using gwt.args: " + (String)props.get("gwt.args")));
        }
        return props;
    }

    private Object quote(String value) {
        if (value.matches(".*[\"\\s].*")) {
            return "\"" + value.replace("\"", "\\\"") + "\"";
        }
        return value;
    }

    public void setSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
        if (systemPropertyVariables.containsKey("gwt.args")) {
            this.getLog().warn((CharSequence)"systemPropertyVariables contains a gwt.args value, this will override all individual options");
        }
        super.setSystemPropertyVariables(systemPropertyVariables);
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
        checksum.add(this.port);
        checksum.add(this.codeServerPort);
        checksum.add(this.deploy);
        checksum.add(this.extra);
        checksum.add(this.workDir);
        checksum.add(this.style);
        checksum.add(this.draftCompile);
        checksum.add(this.localWorkers);
        checksum.add(this.sourceLevel);
        checksum.add(this.testArgs);
        checksum.add(this.useCompilerArgsForTests);
        if (this.useCompilerArgsForTests) {
            checksum.add(this.compilerArgs);
        }
    }

    public String[] getAdditionalClasspathElements() {
        if (this.computedAdditionalClasspathElements == null) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.addAll(this.getProject().getResources());
            resources.addAll(this.getProject().getTestResources());
            ArrayList<String> sourceRoots = new ArrayList<String>();
            sourceRoots.addAll(this.getProject().getCompileSourceRoots());
            sourceRoots.addAll(this.getProject().getTestCompileSourceRoots());
            List<String> filteredSourceRoots = SourcesAsResourcesHelper.filterSourceRoots(this.getLog(), resources, sourceRoots);
            filteredSourceRoots.addAll(Arrays.asList(super.getAdditionalClasspathElements()));
            this.computedAdditionalClasspathElements = sourceRoots.toArray(new String[filteredSourceRoots.size()]);
        }
        return this.computedAdditionalClasspathElements;
    }

    public int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    protected void handleSummary(RunResult summary, Exception firstForkException) throws MojoExecutionException, MojoFailureException {
        SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)summary, (PluginConsoleLogger)this.getConsoleLogger(), (Exception)firstForkException);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isSkipExecution() && !this.isForking()) {
            this.getConsoleLogger().warning("ForkCount=0 is known not to work for GWT tests");
        }
        super.execute();
    }

    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipExec();
    }

    protected String getPluginName() {
        return "GWT tests";
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/*Suite.java", "**/*SuiteNoBrowser.java"};
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    protected String getReportSchemaLocation() {
        return "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report.xsd";
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipExec() {
        return this.skipExec;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public int getSkipAfterFailureCount() {
        return this.skipAfterFailureCount;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public int getForkedProcessExitTimeoutInSeconds() {
        return this.forkedProcessExitTimeoutInSeconds;
    }

    public void setForkedProcessExitTimeoutInSeconds(int forkedProcessExitTimeoutInSeconds) {
        this.forkedProcessExitTimeoutInSeconds = forkedProcessExitTimeoutInSeconds;
    }

    public boolean isUseSystemClassLoader() {
        return true;
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        throw new UnsupportedOperationException("useSystemClassLoader is read-only");
    }

    public boolean isUseManifestOnlyJar() {
        return false;
    }

    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        throw new UnsupportedOperationException("useManifestOnlyJar is read-only");
    }

    public Boolean getFailIfNoSpecifiedTests() {
        return this.failIfNoSpecifiedTests;
    }

    public void setFailIfNoSpecifiedTests(boolean failIfNoSpecifiedTests) {
        this.failIfNoSpecifiedTests = failIfNoSpecifiedTests;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public double getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    public void setParallelTestsTimeoutInSeconds(double parallelTestsTimeoutInSeconds) {
        this.parallelTestsTimeoutInSeconds = parallelTestsTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    public void setParallelTestsTimeoutForcedInSeconds(double parallelTestsTimeoutForcedInSeconds) {
        this.parallelTestsTimeoutForcedInSeconds = parallelTestsTimeoutForcedInSeconds;
    }

    public File[] getSuiteXmlFiles() {
        return (File[])this.suiteXmlFiles.clone();
    }

    public void setSuiteXmlFiles(File[] suiteXmlFiles) {
        this.suiteXmlFiles = (File[])suiteXmlFiles.clone();
    }

    public String getRunOrder() {
        return this.runOrder;
    }

    public void setRunOrder(String runOrder) {
        this.runOrder = runOrder;
    }

    public File getIncludesFile() {
        return this.includesFile;
    }

    public File getExcludesFile() {
        return this.excludesFile;
    }

    protected List<File> suiteXmlFiles() {
        return this.hasSuiteXmlFiles() ? Arrays.asList(this.suiteXmlFiles) : Collections.emptyList();
    }

    protected boolean hasSuiteXmlFiles() {
        return this.suiteXmlFiles != null && this.suiteXmlFiles.length != 0;
    }

    @Override
    @Nullable
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    @Nullable
    public String getStyle() {
        return this.style;
    }

    @Override
    @Nullable
    public Integer getOptimize() {
        return this.optimize;
    }

    @Override
    public File getWarDir() {
        return this.outDir;
    }

    @Override
    public File getWorkDir() {
        return this.workDir;
    }

    @Override
    public File getDeployDir() {
        return this.deploy;
    }

    @Override
    @Nullable
    public File getExtraDir() {
        return this.extra;
    }

    @Override
    public boolean isDraftCompile() {
        return this.draftCompile;
    }

    @Override
    @Nullable
    public String getLocalWorkers() {
        return this.localWorkers;
    }

    @Override
    @Nullable
    public String getSourceLevel() {
        return this.sourceLevel;
    }
}

