/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.generators.EscapeHtmlReference;
import net.masterthought.cucumber.presentation.PresentationMode;
import net.masterthought.cucumber.reducers.ReducingMethod;
import net.masterthought.cucumber.util.Counter;
import net.masterthought.cucumber.util.StepNameFormatter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class AbstractPage {
    private static final Logger LOG = Logger.getLogger(AbstractPage.class.getName());
    private final VelocityEngine engine = new VelocityEngine();
    protected final VelocityContext context = new VelocityContext();
    private final String templateFileName;
    protected final ReportResult reportResult;
    protected final Configuration configuration;

    protected AbstractPage(ReportResult reportResult, String templateFileName, Configuration configuration) {
        this.templateFileName = templateFileName;
        this.reportResult = reportResult;
        this.configuration = configuration;
        this.engine.init(this.buildProperties());
        this.buildGeneralParameters();
    }

    public void generatePage() {
        this.prepareReport();
        this.generateReport();
    }

    public abstract String getWebPage();

    protected abstract void prepareReport();

    private void generateReport() {
        this.context.put("report_file", (Object)this.getWebPage());
        Template template = this.engine.getTemplate("templates/generators/" + this.templateFileName);
        File reportFile = new File(this.configuration.getReportDirectory(), "cucumber-html-reports" + this.configuration.getDirectorySuffixWithSeparator() + File.separatorChar + this.getWebPage());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), StandardCharsets.UTF_8);){
            template.merge((Context)this.context, (Writer)writer);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private Properties buildProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loaders", "class");
        props.setProperty("resource.loader.class.class", ClasspathResourceLoader.class.getCanonicalName());
        props.setProperty("runtime.log", new File(this.configuration.getReportDirectory(), "velocity.log").getPath());
        return props;
    }

    private void buildGeneralParameters() {
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler((EventHandler)new EscapeHtmlReference());
        this.context.attachEventCartridge(ec);
        this.context.put("counter", (Object)new Counter());
        this.context.put("util", (Object)Util.INSTANCE);
        this.context.put("stepNameFormatter", (Object)StepNameFormatter.INSTANCE);
        this.context.put("run_with_jenkins", (Object)this.configuration.containsPresentationMode(PresentationMode.RUN_WITH_JENKINS));
        this.context.put("expand_all_steps", (Object)this.configuration.containsPresentationMode(PresentationMode.EXPAND_ALL_STEPS));
        this.context.put("hide_empty_hooks", (Object)this.configuration.containsReducingMethod(ReducingMethod.HIDE_EMPTY_HOOKS));
        this.context.put("trends_available", (Object)this.configuration.isTrendsAvailable());
        this.context.put("build_project_name", (Object)this.configuration.getProjectName());
        this.context.put("build_number", (Object)this.configuration.getBuildNumber());
        this.context.put("directory_suffix", (Object)this.configuration.getDirectorySuffixWithSeparator());
        String formattedTime = this.reportResult != null ? this.reportResult.getBuildTime() : ReportResult.getCurrentTime();
        this.context.put("build_time", (Object)formattedTime);
        String buildNumber = this.configuration.getBuildNumber();
        if (StringUtils.isNotBlank((CharSequence)buildNumber) && this.configuration.containsPresentationMode(PresentationMode.RUN_WITH_JENKINS)) {
            if (NumberUtils.isCreatable((String)buildNumber)) {
                this.context.put("build_previous_number", (Object)(Integer.parseInt(buildNumber) - 1));
            } else {
                LOG.log(Level.INFO, "Could not parse build number: {0}.", this.configuration.getBuildNumber());
            }
        }
    }
}

